package com.jz.jar.business.wrapper;

import java.util.List;
import java.util.Map;

import com.google.common.collect.Lists;
import com.google.common.collect.Maps;
import com.jz.jooq.franchise.tables.pojos.Appraise;
import com.jz.jooq.franchise.tables.pojos.LessonStudentFeedBack;

/**
 * @Title WPBFeedback
 * @Package com.jz.jar.business.wrapper
 * @author tangjunfeng
 * @date 2019年6月19日 下午4:58:43
 * @version V1.0
 */
public class WPBFeedback {

	/* 老师是否添加了反馈 */
	private Boolean isExistFeedback = false;

	private String content;
	// playabc:上课专心 tomato:专注聆听 -> 感知理解
	private Integer concentration;
	// playabc:学习态度 tomato:勇于提问 -> 多项思维
	private Integer attitude;
	// playabc:不用这个 tomato:积极反馈 -> 成长转变
	private Integer feedback;
	// playabc:课堂表现 tomato:投入课程 -> 创新决策
	private Integer performance;
	// tomato:多元智能
	private Integer multiAi;
	// tomato:艺术视野
	private Integer artHorizons;

	private Map<String, List<Dimension>> reports;

	public void setLessonStudentFeedback(LessonStudentFeedBack fb) {
		this.setIsExistFeedback(true).setContent(fb.getContent()).setConcentration(fb.getConcentration())
				.setAttitude(fb.getAttitude()).setFeedback(fb.getFeedback()).setPerformance(fb.getPerformance())
				.setMultiAi(fb.getMultiAi()).setArtHorizons(fb.getArtHorizons());
	}

	public void addReport(Appraise appraise) {
		if (null == reports) {
			reports = Maps.newHashMap();
		}
		if (!reports.containsKey(appraise.getName()))
			reports.put(appraise.getName(), Lists.newArrayList());
		reports.get(appraise.getName()).add(new Dimension(appraise));
	}

	public Boolean getIsExistFeedback() {
		return isExistFeedback;
	}

	public WPBFeedback setIsExistFeedback(Boolean isExistFeedback) {
		this.isExistFeedback = isExistFeedback;
		return this;
	}

	public String getContent() {
		return content;
	}

	public WPBFeedback setContent(String content) {
		this.content = content;
		return this;
	}

	public Integer getConcentration() {
		return concentration;
	}

	public WPBFeedback setConcentration(Integer concentration) {
		this.concentration = concentration;
		return this;
	}

	public Integer getAttitude() {
		return attitude;
	}

	public WPBFeedback setAttitude(Integer attitude) {
		this.attitude = attitude;
		return this;
	}

	public Integer getFeedback() {
		return feedback;
	}

	public WPBFeedback setFeedback(Integer feedback) {
		this.feedback = feedback;
		return this;
	}

	public Integer getPerformance() {
		return performance;
	}

	public WPBFeedback setPerformance(Integer performance) {
		this.performance = performance;
		return this;
	}

	public Integer getMultiAi() {
		return multiAi;
	}

	public WPBFeedback setMultiAi(Integer multiAi) {
		this.multiAi = multiAi;
		return this;
	}

	public Integer getArtHorizons() {
		return artHorizons;
	}

	public WPBFeedback setArtHorizons(Integer artHorizons) {
		this.artHorizons = artHorizons;
		return this;
	}

	public Map<String, List<Dimension>> getReports() {
		return reports;
	}

	public WPBFeedback setReports(Map<String, List<Dimension>> reports) {
		this.reports = reports;
		return this;
	}

	public class Dimension {
		private String dimension;
		private String ctx;

		public Dimension(Appraise appraise) {
			this.setDimension(appraise.getDimension()).setCtx(appraise.getCtx());
		}

		public String getDimension() {
			return dimension;
		}

		public Dimension setDimension(String dimension) {
			this.dimension = dimension;
			return this;
		}

		public String getCtx() {
			return ctx;
		}

		public Dimension setCtx(String ctx) {
			this.ctx = ctx;
			return this;
		}

	}
}
