/*
 * Decompiled with CFR 0.152.
 */
package com.jz.jar.business.proxy.common;

import com.google.common.collect.Lists;
import com.jz.common.utils.collection.ArrayMapTools;
import com.jz.common.utils.collection.OrderTool;
import com.jz.jar.business.card.ItemCard;
import com.jz.jar.business.request.TomatoCoursePackRequest;
import com.jz.jar.business.wrapper.TomatoCoursePackWrapper;
import com.jz.jar.media.service.TomatoCoursePackService;
import com.jz.jar.media.service.UserCourseService;
import com.jz.jooq.media.tables.pojos.TomatoCoursePack;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import org.apache.commons.collections.MapUtils;
import org.apache.commons.lang.StringUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.context.annotation.Lazy;
import org.springframework.stereotype.Service;

@Lazy
@Service
public class TomatoCoursePackProxy {
    @Autowired
    private TomatoCoursePackService tomatoCoursePackService;
    @Autowired
    private UserCourseService userCourseService;

    public List<TomatoCoursePackWrapper> mutiGetSimplePack(TomatoCoursePackRequest request) {
        if (ArrayMapTools.isEmpty(request.getPids())) {
            return null;
        }
        List packs = this.tomatoCoursePackService.mutiGetOnlinePack(request.getPids(), request.getBrand());
        Map finishMap = null;
        if (request.isWithFinishCnt() && StringUtils.isNotEmpty((String)request.getSuid())) {
            finishMap = this.userCourseService.mutiCalFinishCnt(request.getSuid(), request.getBrand(), request.getPids());
        }
        ArrayList wrappers = Lists.newArrayList();
        for (TomatoCoursePack p : packs) {
            TomatoCoursePackWrapper wrapper = TomatoCoursePackWrapper.ofSimple(p);
            if (request.isWithFinishCnt()) {
                int finishCnt = MapUtils.getIntValue((Map)finishMap, (Object)p.getPid());
                if (finishCnt >= p.getVideoCnt()) {
                    finishCnt = -1;
                }
                wrapper.setFinishCnt(finishCnt);
            }
            wrappers.add(wrapper);
        }
        if (request.isKeepOrder()) {
            return OrderTool.keepOrder(request.getPids(), (Collection)wrappers, TomatoCoursePackWrapper::getPid);
        }
        return wrappers;
    }

    public Map<String, TomatoCoursePackWrapper> mutiGetSimplePackMap(TomatoCoursePackRequest request) {
        request.setKeepOrder(false);
        List<TomatoCoursePackWrapper> wrappers = this.mutiGetSimplePack(request);
        if (wrappers == null) {
            return null;
        }
        return wrappers.stream().collect(Collectors.toMap(p -> p.getPid(), p -> p));
    }

    public List<ItemCard> mutiGetPackCards(TomatoCoursePackRequest request) {
        List<TomatoCoursePackWrapper> wrappers = this.mutiGetSimplePack(request);
        if (wrappers == null) {
            return null;
        }
        return wrappers.stream().map(ItemCard::of).collect(Collectors.toList());
    }

    public Map<String, ItemCard> mutiGetPackCardMap(TomatoCoursePackRequest request) {
        request.setKeepOrder(false);
        List<TomatoCoursePackWrapper> wrappers = this.mutiGetSimplePack(request);
        if (wrappers == null) {
            return null;
        }
        return wrappers.stream().collect(Collectors.toMap(p -> p.getPid(), p -> ItemCard.of(p)));
    }
}

