package com.jz.jar.business.wrapper;

import java.util.List;

import com.google.common.collect.Lists;

public class TagWrapper {
	private TagWrapper() {
	}

	private String tid;
	private String name;
	private List<PlaylistWrapper> playlist;

	public static TagWrapper of() {
		return new TagWrapper();
	}

	public String getTid() {
		return tid;
	}

	public TagWrapper setTid(String tid) {
		this.tid = tid;
		return this;
	}

	public String getName() {
		return name;
	}

	public TagWrapper setName(String name) {
		this.name = name;
		return this;
	}

	public List<PlaylistWrapper> getPlaylist() {
		return playlist;
	}

	public TagWrapper setPlaylist(List<PlaylistWrapper> playlist) {
		this.playlist = playlist;
		return this;
	}

	public TagWrapper addPlaylist(PlaylistWrapper plwer) {
		if (null == plwer)
			return this;
		if (null == this.playlist) {
			this.playlist = Lists.newArrayList();
		}
		this.playlist.add(plwer);
		return this;
	}

}
