package com.jz.jar.business.wrapper;

import com.jz.jar.business.enums.TimeStatus;
import com.jz.jooq.website.tables.pojos.ActivityInfo;

public class ActivityWrapper {
	private ActivityWrapper() {
	}

	private String activityId;
	private String title;
	private Long startTime;
	private Long endTime;
	private String pic;
	private String templateJson;
	private String rule;

	private String schoolName;
	private TimeStatus status;

	public static ActivityWrapper of(ActivityInfo activityInfo) {
		return new ActivityWrapper().setActivityId(activityInfo.getActivityId()).setTitle(activityInfo.getTitle())
				.setStartTime(activityInfo.getStartTime()).setEndTime(activityInfo.getEndTime())
				.setTemplateJson(activityInfo.getTempletJson()).setRule(activityInfo.getRule());
	}

	public String getActivityId() {
		return activityId;
	}

	public ActivityWrapper setActivityId(String activityId) {
		this.activityId = activityId;
		return this;
	}

	public String getSchoolName() {
		return schoolName;
	}

	public ActivityWrapper setSchoolName(String schoolName) {
		this.schoolName = schoolName;
		return this;
	}

	public String getTitle() {
		return title;
	}

	public ActivityWrapper setTitle(String title) {
		this.title = title;
		return this;
	}

	public Long getStartTime() {
		return startTime;
	}

	public ActivityWrapper setStartTime(Long startTime) {
		this.startTime = startTime;
		return this;
	}

	public Long getEndTime() {
		return endTime;
	}

	public ActivityWrapper setEndTime(Long endTime) {
		this.endTime = endTime;
		return this;
	}

	public String getPic() {
		return pic;
	}

	public ActivityWrapper setPic(String pic) {
		this.pic = pic;
		return this;
	}

	public TimeStatus getStatus() {
		return status;
	}

	public ActivityWrapper setStatus(TimeStatus status) {
		this.status = status;
		return this;
	}

	public String getTemplateJson() {
		return templateJson;
	}

	public ActivityWrapper setTemplateJson(String templateJson) {
		this.templateJson = templateJson;
		return this;
	}

	public String getRule() {
		return rule;
	}

	public ActivityWrapper setRule(String rule) {
		this.rule = rule;
		return this;
	}

}