/*
 * Decompiled with CFR 0.152.
 */
package com.jz.jar.business.proxy.common;

import com.google.common.collect.Lists;
import com.google.common.collect.Maps;
import com.jz.common.utils.collection.ArrayMapTools;
import com.jz.common.utils.collection.OrderTool;
import com.jz.common.utils.text.StringTools;
import com.jz.jar.business.bean.AliyunBean;
import com.jz.jar.business.card.ItemCard;
import com.jz.jar.business.enums.PictureCompress;
import com.jz.jar.business.proxy.common.PlaylistVideoProxy;
import com.jz.jar.business.request.NextPlayVideoRequest;
import com.jz.jar.business.request.PlaylistRequest;
import com.jz.jar.business.wrapper.PlaylistWrapper;
import com.jz.jar.business.wrapper.VideoWrapper;
import com.jz.jar.franchise.service.ContractService;
import com.jz.jar.media.enums.BrandEnum;
import com.jz.jar.media.enums.PlaylistType;
import com.jz.jar.media.service.OxTabPlaylistService;
import com.jz.jar.media.service.PlaylistPicsService;
import com.jz.jar.media.service.PlaylistService;
import com.jz.jar.media.service.UserCollectService;
import com.jz.jooq.media.tables.pojos.Playlist;
import com.jz.jooq.media.tables.pojos.PlaylistPics;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import org.apache.commons.collections.MapUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.context.annotation.Lazy;
import org.springframework.stereotype.Service;

@Lazy
@Service
public class PlaylistProxy {
    @Autowired
    private PlaylistService playlistService;
    @Autowired
    private PlaylistPicsService playlistPicsService;
    @Autowired
    private UserCollectService userCollectService;
    @Autowired
    private PlaylistVideoProxy playlistVideoProxy;
    @Autowired
    private ContractService contractService;
    @Autowired
    private OxTabPlaylistService oxTabPlaylistService;

    private Map<String, String> getPlaylistPics(List<PlaylistPics> pics, BrandEnum brand) {
        if (ArrayMapTools.isEmpty(pics)) {
            return null;
        }
        PictureCompress compress = PictureCompress._510x280;
        if (brand == BrandEnum.tomato) {
            compress = PictureCompress._60;
        }
        HashMap has = Maps.newHashMap();
        for (PlaylistPics ps : pics) {
            has.put(ps.getSize().getLiteral(), AliyunBean.getImagesUrl(ps.getUrl(), compress));
        }
        return has;
    }

    public PlaylistWrapper getSinglePlaylist(PlaylistRequest req, BrandEnum brand) {
        Playlist pl = this.playlistService.getOnlinePlaylist(req.getPid(), brand);
        if (null == pl) {
            return null;
        }
        PlaylistWrapper wp = PlaylistWrapper.of(pl).setIsMustHaveContract(false).setIsCollect(false);
        if (StringTools.isNotEmpty((CharSequence)req.getUid())) {
            wp.setIsCollect(this.userCollectService.isCollect(req.getUid(), req.getPid(), brand));
        }
        wp.setCollectCnt(this.userCollectService.countCollectForPlaylist(req.getPid()));
        wp.setPics(this.getPlaylistPics(this.playlistPicsService.getPics(req.getPid()), brand));
        if (PlaylistType.img_txt.isEqualsName(pl.getType())) {
            return wp;
        }
        if (brand == BrandEnum.playabc) {
            wp.setIsMustHaveContract(this.oxTabPlaylistService.isOxTabPlaylist(pl.getPid()));
        }
        if (req.getWithNextVideo().booleanValue()) {
            if (wp.getIsMustHaveContract().booleanValue() && (StringTools.isEmpty((CharSequence)req.getUid()) || !this.contractService.isHaveContract(req.getUid()))) {
                return wp;
            }
            wp.setVideo(this.playlistVideoProxy.getNextPlayVideoForHistory(req.getUid(), pl.getPid(), pl.getWid(), brand, true));
        }
        return wp;
    }

    public List<PlaylistWrapper> getMultiPlaylist(PlaylistRequest req, BrandEnum brand) {
        List<Playlist> videoPlaylist;
        List playlistArray = this.playlistService.getOnlinePlaylist(req.getPids(), brand);
        if (ArrayMapTools.isEmpty((Collection)playlistArray)) {
            return null;
        }
        List collectPlaylist = null;
        List oxPlaylist = null;
        if (null == req.getIsCollect() && StringTools.isNotEmptyAndBlank((String)req.getUid())) {
            collectPlaylist = this.userCollectService.getExistCollect(req.getUid(), req.getPids(), brand);
        }
        Map pid2CollectCnt = this.userCollectService.countCollectForPlaylist(req.getPids());
        boolean isHaveContract = false;
        if (brand == BrandEnum.playabc) {
            oxPlaylist = this.oxTabPlaylistService.findOxTabPlaylistId(req.getPids());
            isHaveContract = StringTools.isNotEmpty((CharSequence)req.getUid()) && this.contractService.isHaveContract(req.getUid());
        }
        Map pid2Pics = this.playlistPicsService.getPicsHas(req.getPids());
        Map<Object, Object> pid2VideoCard = null;
        if (req.getWithNextVideo().booleanValue() && ArrayMapTools.isNotEmpty(videoPlaylist = playlistArray.stream().filter(it -> PlaylistType.video.isEqualsName(it.getType())).collect(Collectors.toList()))) {
            NextPlayVideoRequest nextRequest = NextPlayVideoRequest.of(req.getUid(), req.getSuid(), videoPlaylist);
            nextRequest.setIsSpecial(req.getIsSpecial()).setIsEverday(req.getIsEverday());
            pid2VideoCard = this.playlistVideoProxy.getNextPlayVideoForHistory(nextRequest);
        }
        if (null == pid2VideoCard) {
            pid2VideoCard = Maps.newHashMap();
        }
        ArrayList wrappers = Lists.newArrayList();
        PlaylistWrapper wp = null;
        for (Playlist pl : playlistArray) {
            wp = PlaylistWrapper.of(pl).setIsMustHaveContract(null != oxPlaylist && oxPlaylist.contains(pl.getPid()));
            wp.setPics(this.getPlaylistPics((List)pid2Pics.get(pl.getPid()), brand));
            wp.setCollectCnt(MapUtils.getInteger((Map)pid2CollectCnt, (Object)pl.getPid(), (Integer)0));
            if (null != req.getIsCollect()) {
                wp.setIsCollect(req.getIsCollect());
            } else {
                wp.setIsCollect(collectPlaylist.contains(pl.getPid()));
            }
            if (null != req.getIsRecomm()) {
                wp.setIsRecomm(req.getIsRecomm());
            }
            if (PlaylistType.video.isEqualsName(pl.getType()) && (!wp.getIsMustHaveContract().booleanValue() || wp.getIsMustHaveContract().booleanValue() && isHaveContract)) {
                wp.setVideo((VideoWrapper)pid2VideoCard.get(pl.getPid()));
            }
            wrappers.add(wp);
        }
        return OrderTool.keepOrder(req.getPids(), (Collection)wrappers, PlaylistWrapper::getPid);
    }

    public Map<String, PlaylistWrapper> getMultiPlaylistHas(PlaylistRequest req, BrandEnum brand) {
        List<PlaylistWrapper> playlists = this.getMultiPlaylist(req, brand);
        if (ArrayMapTools.isEmpty(playlists)) {
            return Maps.newHashMap();
        }
        LinkedHashMap pid2Instance = Maps.newLinkedHashMap();
        playlists.forEach(it -> pid2Instance.put(it.getPid(), it));
        return pid2Instance;
    }

    public List<ItemCard> getMultiPlaylistCards(PlaylistRequest req, BrandEnum brand) {
        List<PlaylistWrapper> wrappers = this.getMultiPlaylist(req, brand);
        if (null == wrappers) {
            return null;
        }
        return wrappers.stream().map(ItemCard::of).collect(Collectors.toList());
    }

    public Map<String, ItemCard> getMultiPlaylistCardHas(PlaylistRequest req, BrandEnum brand) {
        List<ItemCard> cards = this.getMultiPlaylistCards(req, brand);
        if (ArrayMapTools.isEmpty(cards)) {
            return Maps.newHashMap();
        }
        LinkedHashMap pid2Card = Maps.newLinkedHashMap();
        cards.forEach(it -> pid2Card.put(it.getPlaylist().getPid(), it));
        return pid2Card;
    }
}

