package com.jz.jar.search.entity.business.tomato;

public enum TomatoSearchType {

	video_playlist(10, "视频专辑"), img_txt_playlist(20, "图文专辑"), video(30, "视频"), img_txt(40, "图文");

	private int code;

	TomatoSearchType(int code, String desc) {
		this.code = code;
	}

	public int getCode() {
		return code;
	}

	public static TomatoSearchType ofCode(int code) {
		for (TomatoSearchType type : TomatoSearchType.values()) {
			if (type.code == code) {
				return type;
			}
		}
		return null;
	}

	public static String getVideoCode(String joint) {
		return video_playlist.code + joint + video.code;
	}

	public static String getImageTxtCode(String joint) {
		return img_txt_playlist.code + joint + img_txt.code;
	}
}
