/*
 * Decompiled with CFR 0.152.
 */
package com.jz.jar.business.wrapper;

import com.jz.jar.business.wrapper.VideoWrapper;
import com.jz.jar.media.enums.BrandEnum;
import com.jz.jooq.media.tables.pojos.Playlist;
import java.util.Map;

public class PlaylistWrapper {
    private String pid;
    private String name;
    private String pic;
    private Map<String, String> pics;
    private Integer videoCnt;
    private Integer difficulty;
    private String target;
    private String remarks;
    private Boolean isCourseware;
    private Boolean isMustHaveContract;
    private String cid;
    private VideoWrapper video;
    private Integer completePercent;
    private Boolean isCollect;
    private Boolean isRecomm;
    private Boolean isComplete;

    private PlaylistWrapper() {
    }

    public static PlaylistWrapper of(Playlist playlist) {
        PlaylistWrapper wrapper = new PlaylistWrapper().setPid(playlist.getPid()).setName(playlist.getName()).setVideoCnt(playlist.getVideoCnt()).setRemarks(playlist.getRemarks()).setIsMustHaveContract(playlist.getIsHaveContract() > 0);
        if (BrandEnum.playabc.name().equals(playlist.getBrand())) {
            wrapper.setDifficulty(playlist.getDifficulty()).setTarget(playlist.getTarget()).setIsCourseware(null != playlist.getIsCourseware() && playlist.getIsCourseware() == 1);
        }
        return wrapper;
    }

    public String getPid() {
        return this.pid;
    }

    public PlaylistWrapper setPid(String pid) {
        this.pid = pid;
        return this;
    }

    public String getName() {
        return this.name;
    }

    public PlaylistWrapper setName(String name) {
        this.name = name;
        return this;
    }

    public String getPic() {
        return this.pic;
    }

    public PlaylistWrapper setPic(String pic) {
        this.pic = pic;
        return this;
    }

    public Map<String, String> getPics() {
        return this.pics;
    }

    public PlaylistWrapper setPics(Map<String, String> pics) {
        this.pics = pics;
        return this;
    }

    public Integer getVideoCnt() {
        return this.videoCnt;
    }

    public PlaylistWrapper setVideoCnt(Integer videoCnt) {
        this.videoCnt = videoCnt;
        return this;
    }

    public Integer getDifficulty() {
        return this.difficulty;
    }

    public PlaylistWrapper setDifficulty(Integer difficulty) {
        this.difficulty = difficulty;
        return this;
    }

    public String getTarget() {
        return this.target;
    }

    public PlaylistWrapper setTarget(String target) {
        this.target = target;
        return this;
    }

    public String getRemarks() {
        return this.remarks;
    }

    public PlaylistWrapper setRemarks(String remarks) {
        this.remarks = remarks;
        return this;
    }

    public Boolean getIsCourseware() {
        return this.isCourseware;
    }

    public PlaylistWrapper setIsCourseware(Boolean isCourseware) {
        this.isCourseware = isCourseware;
        return this;
    }

    public Boolean getIsMustHaveContract() {
        return this.isMustHaveContract;
    }

    public PlaylistWrapper setIsMustHaveContract(Boolean isMustHaveContract) {
        this.isMustHaveContract = isMustHaveContract;
        return this;
    }

    public String getCid() {
        return this.cid;
    }

    public PlaylistWrapper setCid(String cid) {
        this.cid = cid;
        return this;
    }

    public VideoWrapper getVideo() {
        return this.video;
    }

    public PlaylistWrapper setVideo(VideoWrapper video) {
        this.video = video;
        return this;
    }

    public Integer getCompletePercent() {
        return this.completePercent;
    }

    public PlaylistWrapper setCompletePercent(Integer completePercent) {
        this.completePercent = completePercent;
        return this;
    }

    public Boolean getIsCollect() {
        return this.isCollect;
    }

    public PlaylistWrapper setIsCollect(Boolean isCollect) {
        this.isCollect = isCollect;
        return this;
    }

    public Boolean getIsRecomm() {
        return this.isRecomm;
    }

    public PlaylistWrapper setIsRecomm(Boolean isRecomm) {
        this.isRecomm = isRecomm;
        return this;
    }

    public Boolean getIsComplete() {
        return this.isComplete;
    }

    public PlaylistWrapper setIsComplete(Boolean isComplete) {
        this.isComplete = isComplete;
        return this;
    }
}

