/*
 * Decompiled with CFR 0.152.
 */
package com.jz.aliyun.callback;

import com.google.common.collect.Lists;
import com.google.common.collect.Maps;
import com.google.common.io.CharStreams;
import com.jz.common.utils.text.StringTools;
import java.io.ByteArrayInputStream;
import java.io.DataInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.UnsupportedEncodingException;
import java.net.HttpURLConnection;
import java.net.URL;
import java.security.PublicKey;
import java.security.Signature;
import java.security.cert.Certificate;
import java.security.cert.CertificateFactory;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Enumeration;
import java.util.HashMap;
import java.util.Locale;
import java.util.Map;
import javax.servlet.http.HttpServletRequest;
import org.apache.commons.codec.binary.Base64;
import org.apache.http.MethodNotSupportedException;
import org.dom4j.Document;
import org.dom4j.DocumentException;
import org.dom4j.Element;
import org.dom4j.io.SAXReader;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class MtsCallback {
    private static final Logger logger = LoggerFactory.getLogger(MtsCallback.class);

    public static boolean authenticate(HttpServletRequest request) throws MethodNotSupportedException {
        HashMap headers = Maps.newHashMap();
        Enumeration headerNames = request.getHeaderNames();
        while (headerNames.hasMoreElements()) {
            String name = (String)headerNames.nextElement();
            headers.put(name, request.getHeader(name));
        }
        logger.info("transCodeCallback.headers : {}", (Object)headers);
        if (!headers.containsKey("x-mns-signing-cert-url")) {
            logger.error("not found cert url");
            return false;
        }
        String certUrl = new String(Base64.decodeBase64((String)((String)headers.get("x-mns-signing-cert-url"))));
        String method = request.getMethod().toUpperCase(Locale.ENGLISH);
        if (!StringTools.contains((String[])new String[]{method, "GET", "HEAD", "POST"})) {
            throw new MethodNotSupportedException(method + " method not supported");
        }
        if (MtsCallback.authenticate(method, request.getRequestURI(), headers, certUrl)) {
            return true;
        }
        logger.error("authenticate fail");
        return false;
    }

    private static boolean authenticate(String method, String uri, Map<String, String> headers, String cert) {
        String str2sign = MtsCallback.getSignStr(method, uri, headers);
        String signature = headers.get("authorization");
        byte[] decodedSign = Base64.decodeBase64((String)signature);
        try {
            URL url = new URL(cert);
            HttpURLConnection conn = (HttpURLConnection)url.openConnection();
            DataInputStream in = new DataInputStream(conn.getInputStream());
            CertificateFactory cf = CertificateFactory.getInstance("X.509");
            Certificate c = cf.generateCertificate(in);
            PublicKey pk = c.getPublicKey();
            Signature signetcheck = Signature.getInstance("SHA1withRSA");
            signetcheck.initVerify(pk);
            signetcheck.update(str2sign.getBytes());
            return signetcheck.verify(decodedSign);
        }
        catch (Exception e) {
            logger.error("authenticate fail, " + e.getMessage(), (Throwable)e);
            return false;
        }
    }

    private static String getSignStr(String method, String uri, Map<String, String> headers) {
        StringBuilder sb = new StringBuilder().append(method).append("\n");
        sb.append(StringTools.ternary((String)headers.get("content-md5"))).append("\n");
        sb.append(StringTools.ternary((String)headers.get("content-type"))).append("\n");
        sb.append(StringTools.ternary((String)headers.get("date"))).append("\n");
        ArrayList xmnsArray = Lists.newArrayList();
        for (Map.Entry<String, String> entry : headers.entrySet()) {
            if (!entry.getKey().startsWith("x-mns-")) continue;
            xmnsArray.add(entry.getKey() + ":" + entry.getValue());
        }
        Collections.sort(xmnsArray);
        xmnsArray.forEach(kv -> sb.append((String)kv).append("\n"));
        sb.append(uri);
        return sb.toString();
    }

    public static String getMessage(HttpServletRequest request) throws UnsupportedEncodingException, IOException, DocumentException {
        String body = CharStreams.toString((Readable)new InputStreamReader((InputStream)request.getInputStream(), "UTF-8"));
        logger.info("transCodeCallback.body : {}", (Object)body);
        if (StringTools.isEmptyAndBlank((String)body)) {
            throw new NullPointerException();
        }
        SAXReader saxReader = new SAXReader();
        Document document = saxReader.read((InputStream)new ByteArrayInputStream(body.getBytes("UTF-8")));
        Element root = document.getRootElement();
        return root.element("Message").getTextTrim();
    }
}

