package com.jz.aliyun.tools;

import java.util.HashMap;
import java.util.Map;

import com.jz.common.utils.collection.ArrayMapTools;
import com.jz.common.utils.http.ConnectPost;
import com.jz.common.utils.json.GsonTools;
import com.jz.common.utils.text.StringTools;

public class CDNTools {

	@SuppressWarnings("unchecked")
	public static boolean refreshCdnCache(String accessKeyId, String accessKeySecret, String path) throws Exception {
		Map<String, String> param = new HashMap<String, String>();
		param.put("AccessKeyId", accessKeyId);
		param.put("Format", "JSON");
		param.put("Version", "2014-11-11");
		param.put("SignatureMethod", "HMAC-SHA1");
		param.put("SignatureVersion", "1.0");
		param.put("SignatureNonce", StringTools.RandomString.random(64));
		param.put("Timestamp", AliyunNewSignTool.getFormatIso8601Date());
		param.put("Action", "RefreshObjectCaches");
		param.put("ObjectPath", path);
		param.put("ObjectType", "File");
		param.put("Signature", AliyunNewSignTool.generateSign("POST", param, accessKeySecret));
		String result = ConnectPost.send("https://cdn.aliyuncs.com", param, AliyunNewSignTool.CHARSET_UTF8);
		if (StringTools.isEmpty(result))
			return false;
		Map<String, String> has = GsonTools.gson.fromJson(result, Map.class);
		return ArrayMapTools.containsKeys(has, "RefreshTaskId", "RequestId");
	}

}