/*
 * Decompiled with CFR 0.152.
 */
package com.jz.aliyun.tools;

import com.aliyun.oss.OSSClient;
import com.google.common.collect.Maps;
import com.jz.aliyun.beans.AliyunConfig;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.InputStream;
import java.net.URL;
import java.util.Calendar;
import java.util.Collection;
import java.util.HashMap;
import java.util.Map;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class OssTools {
    private static final Logger logger = LoggerFactory.getLogger(OssTools.class);
    private AliyunConfig aliyunConfig;

    private OssTools() {
    }

    private OssTools(AliyunConfig aliyunConfig) {
        this.aliyunConfig = aliyunConfig;
    }

    public static OssTools getInstance(AliyunConfig aliyunConfig) {
        return new OssTools(aliyunConfig);
    }

    public void upload(String localFilePath, String ossFilePath) throws FileNotFoundException {
        logger.info("aliyun upload file : {} => {}", (Object)localFilePath, (Object)ossFilePath);
        this.upload(new FileInputStream(new File(localFilePath)), ossFilePath);
    }

    private OSSClient getOssClient() {
        return new OSSClient(this.aliyunConfig.getEndpoint(), this.aliyunConfig.getAccessKeyId(), this.aliyunConfig.getAccessKeySecret());
    }

    public void upload(InputStream inputStream, String ossFilePath) throws FileNotFoundException {
        OSSClient ossClient = this.getOssClient();
        ossClient.putObject(this.aliyunConfig.getBucketName(), ossFilePath, inputStream);
        ossClient.shutdown();
    }

    public void copy(String sourcePath, String destinationPath) throws FileNotFoundException {
        logger.info("aliyun copy file : {} => {}", (Object)sourcePath, (Object)destinationPath);
        OSSClient ossClient = this.getOssClient();
        ossClient.copyObject(this.aliyunConfig.getBucketName(), sourcePath, this.aliyunConfig.getBucketName(), destinationPath);
        ossClient.shutdown();
    }

    public void delete(String filePath) throws FileNotFoundException {
        logger.info("aliyun delete file : {} => {}", (Object)this.aliyunConfig.getBucketName(), (Object)filePath);
        OSSClient ossClient = this.getOssClient();
        ossClient.deleteObject(this.aliyunConfig.getBucketName(), filePath);
        ossClient.shutdown();
    }

    public void move(String sourcePath, String destinationPath) {
        logger.info("aliyun mv file : {} => {}", (Object)sourcePath, (Object)destinationPath);
        OSSClient ossClient = this.getOssClient();
        ossClient.copyObject(this.aliyunConfig.getSourceBucketName(), sourcePath, this.aliyunConfig.getTargetBucketName(), destinationPath);
        ossClient.deleteObject(this.aliyunConfig.getSourceBucketName(), sourcePath);
        ossClient.shutdown();
    }

    public String getUrl(String fileUrl, int expireSeconds) {
        OSSClient ossClient = this.getOssClient();
        Calendar expiration = Calendar.getInstance();
        expiration.add(13, expireSeconds);
        URL url = ossClient.generatePresignedUrl(this.aliyunConfig.getBucketName(), fileUrl, expiration.getTime());
        ossClient.shutdown();
        return url.toString();
    }

    public Map<String, String> getUrl(Collection<String> fileUrls, int expireSeconds) {
        OSSClient ossClient = this.getOssClient();
        Calendar expiration = Calendar.getInstance();
        expiration.add(13, expireSeconds);
        HashMap source2Target = Maps.newHashMap();
        for (String tempUrl : fileUrls) {
            URL url = ossClient.generatePresignedUrl(this.aliyunConfig.getBucketName(), tempUrl, expiration.getTime());
            source2Target.put(tempUrl, url.toString());
        }
        ossClient.shutdown();
        return source2Target;
    }
}

