/*
 * Decompiled with CFR 0.152.
 */
package com.gymchina.pay.client;

import com.google.common.collect.Maps;
import com.gymchina.bean.response.GymchinaPayCommonResponse;
import com.gymchina.bean.tools.PaymentHttpTool;
import com.gymchina.pay.client.configuration.GymchinaPayClientConfiguration;
import com.gymchina.pay.client.request.interfaces.IMultiRequest;
import com.gymchina.pay.client.request.interfaces.IRequest;
import com.jz.common.utils.collection.ArrayMapTools;
import com.jz.common.utils.http.ConnectPost;
import com.jz.common.utils.json.GsonTools;
import com.jz.common.utils.text.StringTools;
import java.lang.reflect.Field;
import java.util.HashMap;
import java.util.Map;
import java.util.concurrent.ConcurrentLinkedQueue;
import java.util.function.BiConsumer;
import org.apache.commons.beanutils.BeanUtils;
import org.apache.commons.lang3.tuple.Pair;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class PayClient {
    private static final Logger logger = LoggerFactory.getLogger(PayClient.class);
    private String payUrl;
    private String signKey;
    private String utf8 = "utf-8";
    private boolean showLog;

    private PayClient(String payUrl, String signKey, boolean showLog) {
        this.payUrl = payUrl;
        this.signKey = signKey;
        this.showLog = showLog;
    }

    public static PayClient getClient(String payUrl, String signKey, boolean showLog) {
        if (!StringTools.startsWithAny((CharSequence)payUrl, (CharSequence[])new CharSequence[]{"http://", "https://"})) {
            throw new IllegalArgumentException("invalid pay url");
        }
        return new PayClient(payUrl, signKey, showLog);
    }

    public static PayClient getClient(String payUrl, String signKey) {
        return PayClient.getClient(payUrl, signKey, false);
    }

    public static PayClient getClient() {
        return PayClient.getClient(GymchinaPayClientConfiguration.getPayServer(), GymchinaPayClientConfiguration.getSignKey());
    }

    public GymchinaPayCommonResponse invokeGymchinaPay(IRequest request) throws Exception {
        Map<String, String> param = this.getParam(request);
        param.put("sign", PaymentHttpTool.getGymchinaPayParamSign(param, (String)this.signKey));
        String url = this.getRequestUrl(request.mapping());
        String result = ConnectPost.send((String)url, param, (String)this.utf8, (boolean)this.showLog);
        if (null == result) {
            return null;
        }
        return (GymchinaPayCommonResponse)GsonTools.gson.fromJson(result, GymchinaPayCommonResponse.class);
    }

    public void invokeGymchinaPay(IMultiRequest multiRequest, final BiConsumer<String, GymchinaPayCommonResponse> consumer) {
        final ConcurrentLinkedQueue<Pair<String, ? extends IRequest>> requests = multiRequest.changeToRequest();
        if (ArrayMapTools.isEmpty(requests)) {
            return;
        }
        if (null == GymchinaPayClientConfiguration.getThreadPool()) {
            throw new UnsupportedOperationException();
        }
        for (int i = 0; i < GymchinaPayClientConfiguration.getMaxSize(); ++i) {
            GymchinaPayClientConfiguration.getThreadPool().execute(new Runnable(){

                @Override
                public void run() {
                    try {
                        Pair poll = null;
                        while (!requests.isEmpty()) {
                            poll = (Pair)requests.poll();
                            GymchinaPayCommonResponse response = PayClient.this.invokeGymchinaPay((IRequest)poll.getRight());
                            if (null == consumer) continue;
                            consumer.accept(poll.getKey(), response);
                        }
                    }
                    catch (Exception e) {
                        logger.error(e.getMessage(), (Throwable)e);
                    }
                }
            });
        }
    }

    private Map<String, String> getParam(IRequest request) throws Exception {
        HashMap has = Maps.newHashMap();
        String value = null;
        for (Field field : request.getClass().getDeclaredFields()) {
            value = BeanUtils.getSimpleProperty((Object)request, (String)field.getName());
            if (null == value) continue;
            has.put(field.getName(), value);
        }
        return has;
    }

    private String getRequestUrl(String mapping) {
        if (mapping.startsWith("/")) {
            mapping = mapping.substring(1);
        }
        if (this.payUrl.endsWith("/")) {
            return this.payUrl + mapping;
        }
        return this.payUrl + "/" + mapping;
    }
}

