/*
 * Decompiled with CFR 0.152.
 */
package com.gymchina.cypher.encrypt;

import com.gymchina.cypher.encrypt.EncryptConst;
import java.security.Key;
import java.security.SecureRandom;
import javax.crypto.Cipher;
import javax.crypto.KeyGenerator;
import javax.crypto.SecretKey;
import javax.crypto.spec.IvParameterSpec;
import javax.crypto.spec.SecretKeySpec;
import org.apache.commons.codec.binary.Base64;

public class AESEncryption {
    private static SecretKeySpec getSecretKey(String secretKey) throws Exception {
        KeyGenerator keyGenerator = KeyGenerator.getInstance("AES");
        SecureRandom secureRandom = SecureRandom.getInstance("SHA1PRNG");
        secureRandom.setSeed(secretKey.getBytes());
        keyGenerator.init(EncryptConst.SECRET_KEY_SIZE, secureRandom);
        SecretKey secret = keyGenerator.generateKey();
        byte[] keyBytes = secret.getEncoded();
        return new SecretKeySpec(keyBytes, "AES");
    }

    private static byte[] cipherHandle(byte[] bys, EncryptConst.CipherMode cipherMode, String secretKey, String spec) throws Exception {
        SecretKeySpec kSpec = AESEncryption.getSecretKey(secretKey);
        IvParameterSpec ivSpec = new IvParameterSpec(spec.getBytes("UTF-8"));
        Cipher cipher = Cipher.getInstance("AES/CBC/PKCS5Padding");
        cipher.init(cipherMode.getMode(), (Key)kSpec, ivSpec);
        return cipher.doFinal(bys);
    }

    public static String encrypt(String context, String secretKey, String spec) {
        try {
            byte[] bys = AESEncryption.cipherHandle(context.getBytes(), EncryptConst.CipherMode.encrypt, secretKey, spec);
            return Base64.encodeBase64String((byte[])bys);
        }
        catch (Exception e) {
            e.printStackTrace();
            return null;
        }
    }

    public static String encrypt(String context) {
        return AESEncryption.encrypt(context, EncryptConst.SECRET_KEY, EncryptConst.IV_SPEC);
    }

    public static String decrypt(String context, String secretKey, String spec) {
        try {
            byte[] bys = AESEncryption.cipherHandle(Base64.decodeBase64((String)context), EncryptConst.CipherMode.decrypt, secretKey, spec);
            return new String(bys);
        }
        catch (Exception e) {
            e.printStackTrace();
            return null;
        }
    }

    public static String decrypt(String context) {
        return AESEncryption.decrypt(context, EncryptConst.SECRET_KEY, EncryptConst.IV_SPEC);
    }
}

