/*
 * Decompiled with CFR 0.152.
 */
package com.gymchina.bean.tools;

import com.google.common.collect.Lists;
import com.google.common.collect.Maps;
import com.jz.common.utils.collection.ArrayMapTools;
import com.jz.common.utils.security.EncryptionTools;
import com.jz.common.utils.text.StringTools;
import java.io.ByteArrayInputStream;
import java.io.InputStream;
import java.io.UnsupportedEncodingException;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.dom4j.Document;
import org.dom4j.DocumentException;
import org.dom4j.DocumentHelper;
import org.dom4j.Element;
import org.dom4j.io.SAXReader;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class PaymentHttpTool {
    private static final Logger logger = LoggerFactory.getLogger(PaymentHttpTool.class);

    public static String wechatParseToXml(Map<String, String> params) {
        if (ArrayMapTools.isEmpty(params)) {
            return null;
        }
        Document document = DocumentHelper.createDocument();
        Element root = document.addElement("xml");
        params.forEach((key, value) -> root.addElement(key).addText(value));
        return document.asXML();
    }

    public static Map<String, String> wechatParseToMap(String xml) {
        if (StringTools.isEmpty((CharSequence)xml)) {
            return null;
        }
        try {
            SAXReader saxReader = new SAXReader();
            Document document = saxReader.read((InputStream)new ByteArrayInputStream(xml.getBytes("UTF-8")));
            Element root = document.getRootElement();
            List elements = root.elements();
            HashMap has = Maps.newHashMap();
            for (Element el : elements) {
                if (!StringTools.allNotEmpty((String[])new String[]{el.getName(), el.getTextTrim()})) continue;
                has.put(el.getName(), el.getTextTrim());
            }
            return has;
        }
        catch (UnsupportedEncodingException | DocumentException e) {
            return null;
        }
    }

    public static StringBuffer getSortedParamsStringBuffer(Map<String, String> paramsMap) {
        if (ArrayMapTools.isEmpty(paramsMap)) {
            return null;
        }
        ArrayList respParamsKeys = Lists.newArrayList(paramsMap.keySet());
        Collections.sort(respParamsKeys);
        StringBuffer respParamsStrBuffer = new StringBuffer();
        for (String key : respParamsKeys) {
            if (!StringTools.allNotEmpty((String[])new String[]{key, paramsMap.get(key)})) continue;
            respParamsStrBuffer.append(key).append("=").append(paramsMap.get(key)).append("&");
        }
        return respParamsStrBuffer.delete(respParamsStrBuffer.length() - 1, respParamsStrBuffer.length());
    }

    public static String getWechatSign(Map<String, String> params, String key) {
        if (ArrayMapTools.isEmpty(params) || StringTools.isEmpty((CharSequence)key)) {
            return null;
        }
        StringBuffer waitSign = PaymentHttpTool.getSortedParamsStringBuffer(params);
        waitSign.append("&key=").append(key);
        return EncryptionTools.MD5((String)waitSign.toString(), (boolean)true);
    }

    public static StringBuffer getSortedParamsValueMarkStringBuffer(Map<String, String> paramsMap, boolean slash) {
        if (ArrayMapTools.isEmpty(paramsMap)) {
            return null;
        }
        ArrayList respParamsKeys = Lists.newArrayList(paramsMap.keySet());
        StringBuffer respParamsStrBuffer = new StringBuffer();
        for (String key : respParamsKeys) {
            if (!StringTools.allNotEmpty((String[])new String[]{key, paramsMap.get(key)})) continue;
            if (respParamsStrBuffer.toString().length() > 0) {
                respParamsStrBuffer.append("&");
            }
            if (slash) {
                respParamsStrBuffer.append(key).append("=\\\"");
                respParamsStrBuffer.append(paramsMap.get(key)).append("\\\"");
                continue;
            }
            respParamsStrBuffer.append(key).append("=\"");
            respParamsStrBuffer.append(paramsMap.get(key)).append("\"");
        }
        return respParamsStrBuffer;
    }

    public static String getGymchinaPayParamSign(Map<String, String> paramMap, String key) {
        if (ArrayMapTools.isEmpty(paramMap) || StringTools.isEmpty((CharSequence)key)) {
            return null;
        }
        StringBuffer buffer = PaymentHttpTool.getSortedParamsStringBuffer(paramMap);
        return EncryptionTools.MD5((String)buffer.append("&gymchina_pay_sign_key=").append(key).insert(0, key).toString());
    }

    public static Map<String, String> alipaySingleTradeQueryResult2Map(String xml, String charsetName) {
        if (StringTools.isEmpty((CharSequence)xml)) {
            return null;
        }
        try {
            SAXReader saxReader = new SAXReader();
            Document document = saxReader.read((InputStream)new ByteArrayInputStream(xml.getBytes(charsetName)));
            Element root = document.getRootElement();
            if (!"T".equals(root.element("is_success").getTextTrim())) {
                return null;
            }
            Element trade = root.element("response").element("trade");
            List elements = trade.elements();
            HashMap has = Maps.newHashMap();
            for (Element el : elements) {
                if (!StringTools.allNotEmpty((String[])new String[]{el.getName(), el.getTextTrim()})) continue;
                has.put(el.getName(), el.getTextTrim());
            }
            return has;
        }
        catch (UnsupportedEncodingException | DocumentException e) {
            logger.error(e.getMessage(), e);
            return null;
        }
    }

    public static String getAlipay20SourceData(String methodName, String response) {
        String prifix = methodName.replace(".", "_") + "_response";
        int indexOfRootNode = response.indexOf(prifix);
        int indexOfSign = response.indexOf("\"sign\"");
        if (indexOfRootNode < 0 || indexOfSign < 0) {
            return null;
        }
        int signDataStartIndex = indexOfRootNode + prifix.length() + 2;
        int signDataEndIndex = indexOfSign - 1;
        return response.substring(signDataStartIndex, signDataEndIndex);
    }
}

