package com.gymchina.tiny.spring.guide.property;

import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import java.util.Map;

import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.cloud.bootstrap.config.PropertySourceLocator;
import org.springframework.cloud.config.client.ConfigServicePropertySourceLocator;
import org.springframework.context.annotation.Configuration;
import org.springframework.core.env.CompositePropertySource;
import org.springframework.core.env.Environment;
import org.springframework.core.env.MapPropertySource;
import org.springframework.core.env.PropertySource;

import com.gymchina.tiny.common.global.TinyCommon;

/**
 * @Title TinyPropertySourceLoder
 * @Package com.gymchina.tiny.spring.guide.property
 * @author tangjunfeng
 * @date 2018年12月28日 上午10:19:05
 * @version V1.0
 */
@Configuration
public class TinyPropertySourceLoder implements PropertySourceLocator {

	@Autowired
	private List<PropertySourceLocator> propertySourceLocators = new ArrayList<>();

	@Override
	public PropertySource<?> locate(Environment environment) {
		if (propertySourceLocators.isEmpty())
			return null;
		PropertySourceLocator locator = getConfigServicePropertySourceLocator();
		if (null == locator)
			return null;
		PropertySource<?> resultLocate = locator.locate(environment);
		if (null == resultLocate)
			return null;
		Map<String, Object> allProperties = new HashMap<>();
		CompositePropertySource propertySource = (CompositePropertySource) resultLocate;
		Collection<PropertySource<?>> propertySources = propertySource.getPropertySources();
		for (PropertySource<?> properties : propertySources) {
			if (properties instanceof MapPropertySource) {
				MapPropertySource propertyMap = (MapPropertySource) properties;
				allProperties.putAll(propertyMap.getSource());
			}
		}

		if (!allProperties.isEmpty()) {
			TinyCommon.properties.clear();
			TinyCommon.properties.putAll(allProperties);
		}
		return null;
	}

	private PropertySourceLocator getConfigServicePropertySourceLocator() {
		for (PropertySourceLocator locator : propertySourceLocators) {
			if (locator instanceof ConfigServicePropertySourceLocator) {
				return locator;
			}
		}
		return null;
	}
}
