package com.gymchina.tiny.register.configuration;

import java.util.ArrayList;
import java.util.List;

import com.gymchina.tiny.common.global.TinyCommon;
import com.gymchina.tiny.register.configuration.definition.TinyDataSourceBeanDefinition;
import com.gymchina.tiny.register.configuration.definition.TinySimpleBeanDefinition;

/**
 * @Title TinyConfigurationRegistrar
 * @Package com.gymchina.tiny.register.configuration
 * @author tangjunfeng
 * @date 2019年3月7日 下午4:25:55
 * @version V1.0
 */
public class TinyConfigurationRegistrar {

	private static TinyConfigurationRegistrar _this;

	public static TinyConfigurationRegistrar getInstance() {
		if (null == _this) {
			_this = new TinyConfigurationRegistrar();
			_this.beanDefinitions = new ArrayList<>();
		}
		return _this;
	}

	private List<TinySimpleBeanDefinition> beanDefinitions;

	public TinyConfigurationRegistrar addBean(TinySimpleBeanDefinition beanDefinition) {
		autoEnableForbiddenDataSourceConfiguration(beanDefinition);
		beanDefinitions.add(beanDefinition);
		return this;
	}

	public List<TinySimpleBeanDefinition> getBeanDefinitions() {
		return beanDefinitions;
	}

	private boolean isLoadingForbidden = false;

	/*
	 * auto using atomikos for multiple data sources, so must forbidden
	 * AutoDataSourceConfiguration and XADataSourceAutoConfiguration
	 */
	private void autoEnableForbiddenDataSourceConfiguration(TinySimpleBeanDefinition beanDefinition) {
		if (isLoadingForbidden)
			return;
		if (TinyDataSourceBeanDefinition.class.isAssignableFrom(beanDefinition.getClass())) {
			TinyCommon.tinyFrameworkRunners.add(new TinyForbiddenAutoDataSourceConfiguration());
			isLoadingForbidden = true;
		}
	}

}
