/*
 * Decompiled with CFR 0.152.
 */
package com.gymchina.tiny.register.handler;

import com.gymchina.tiny.register.configuration.TinyConfigurationRegistrar;
import com.gymchina.tiny.register.configuration.definition.TinyDataSourceBeanDefinition;
import com.gymchina.tiny.register.configuration.definition.TinyJedisClusterBeanDefinition;
import com.gymchina.tiny.register.configuration.definition.TinySimpleBeanDefinition;
import com.gymchina.tiny.register.handler.TinySimpleDataSourceBeanDefinition;
import com.gymchina.tiny.register.handler.TinySimpleJedisClusterBeanDefinition;
import java.util.ArrayList;
import java.util.List;
import org.springframework.beans.factory.support.BeanDefinitionRegistry;
import org.springframework.boot.context.properties.bind.Binder;
import org.springframework.context.EnvironmentAware;
import org.springframework.context.annotation.Configuration;
import org.springframework.context.annotation.Import;
import org.springframework.context.annotation.ImportBeanDefinitionRegistrar;
import org.springframework.core.env.Environment;
import org.springframework.core.type.AnnotationMetadata;

@Configuration
@Import(value={TinySimpleRegisterBeanDefinition.class})
public class TinySimpleRegisterBeanDefinition
implements ImportBeanDefinitionRegistrar,
EnvironmentAware {
    private static final Class<TinyDataSourceBeanDefinition> datasourceClass = TinyDataSourceBeanDefinition.class;
    private static final Class<TinyJedisClusterBeanDefinition> jedisClass = TinyJedisClusterBeanDefinition.class;
    private Binder binder;

    public void registerBeanDefinitions(AnnotationMetadata importingClassMetadata, BeanDefinitionRegistry registry) {
        TinyConfigurationRegistrar configurationRegistrar = TinyConfigurationRegistrar.getInstance();
        List<TinySimpleBeanDefinition> beanDefinitions = configurationRegistrar.getBeanDefinitions();
        if (null == beanDefinitions || beanDefinitions.isEmpty()) {
            return;
        }
        ArrayList<TinyDataSourceBeanDefinition> dataSources = new ArrayList<TinyDataSourceBeanDefinition>();
        ArrayList<TinyJedisClusterBeanDefinition> jedisClusters = new ArrayList<TinyJedisClusterBeanDefinition>();
        for (TinySimpleBeanDefinition beanDefinition : beanDefinitions) {
            if (this.addBeanDefinition(beanDefinition, dataSources, datasourceClass)) continue;
            this.addBeanDefinition(beanDefinition, jedisClusters, jedisClass);
        }
        if (!dataSources.isEmpty()) {
            new TinySimpleDataSourceBeanDefinition(this.binder).registerDataSources(registry, dataSources);
        }
        if (!jedisClusters.isEmpty()) {
            new TinySimpleJedisClusterBeanDefinition(this.binder).registerJedisCluster(registry, jedisClusters);
        }
    }

    private <T> boolean addBeanDefinition(TinySimpleBeanDefinition bean, List<T> beans, Class<T> clazz) {
        if (!clazz.isAssignableFrom(bean.getClass())) {
            return false;
        }
        beans.add(bean);
        return true;
    }

    public void setEnvironment(Environment environment) {
        this.binder = Binder.get((Environment)environment);
    }
}

