/*
 * Decompiled with CFR 0.152.
 */
package com.gymchina.tiny.register.handler;

import com.gymchina.tiny.register.business.JedisClusterProperties;
import com.gymchina.tiny.register.configuration.definition.TinyJedisClusterBeanDefinition;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import org.springframework.beans.factory.config.BeanDefinition;
import org.springframework.beans.factory.config.ConstructorArgumentValues;
import org.springframework.beans.factory.support.BeanDefinitionRegistry;
import org.springframework.beans.factory.support.GenericBeanDefinition;
import org.springframework.boot.context.properties.bind.Binder;
import redis.clients.jedis.HostAndPort;
import redis.clients.jedis.JedisCluster;

public class TinySimpleJedisClusterBeanDefinition {
    private Binder binder;

    public TinySimpleJedisClusterBeanDefinition(Binder binder) {
        this.binder = binder;
    }

    public void registerJedisCluster(BeanDefinitionRegistry registry, List<TinyJedisClusterBeanDefinition> jedisClusters) {
        if (null == jedisClusters || jedisClusters.isEmpty()) {
            return;
        }
        Class<JedisClusterProperties> propertyClass = JedisClusterProperties.class;
        JedisClusterProperties properties = null;
        for (TinyJedisClusterBeanDefinition beanDefinition : jedisClusters) {
            properties = (JedisClusterProperties)((Object)this.binder.bind(beanDefinition.getPropertiesPrefix(), propertyClass).get());
            GenericBeanDefinition genericBeanDefinition = new GenericBeanDefinition();
            genericBeanDefinition.setBeanClass(JedisCluster.class);
            genericBeanDefinition.setPrimary(beanDefinition.getPrimary().booleanValue());
            ConstructorArgumentValues values = new ConstructorArgumentValues();
            values.addIndexedArgumentValue(0, this.getJedisClusterHosts(properties));
            values.addIndexedArgumentValue(1, (Object)properties.getTimeOut());
            values.addIndexedArgumentValue(2, (Object)properties.getMaxRedirction());
            values.addIndexedArgumentValue(3, (Object)properties);
            genericBeanDefinition.setConstructorArgumentValues(values);
            registry.registerBeanDefinition(beanDefinition.getBeanName(), (BeanDefinition)genericBeanDefinition);
        }
    }

    private Set<HostAndPort> getJedisClusterHosts(JedisClusterProperties properties) {
        HashSet<HostAndPort> hostPortArray = new HashSet<HostAndPort>();
        for (String temp : properties.getHostPort().split(",")) {
            if (null == temp || temp.trim().length() <= 0) continue;
            String[] hp = temp.split(":");
            hostPortArray.add(new HostAndPort(hp[0], Integer.parseInt(hp[1])));
        }
        return hostPortArray;
    }
}

