package com.gymchina.tiny.register.configuration;

import java.lang.reflect.Field;
import java.lang.reflect.InvocationHandler;
import java.lang.reflect.Proxy;
import java.util.Arrays;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;

import org.springframework.boot.autoconfigure.EnableAutoConfiguration;
import org.springframework.boot.autoconfigure.SpringBootApplication;
import org.springframework.boot.autoconfigure.jdbc.DataSourceAutoConfiguration;
import org.springframework.boot.autoconfigure.jdbc.XADataSourceAutoConfiguration;
import org.springframework.transaction.annotation.EnableTransactionManagement;
import org.springframework.util.ClassUtils;

import com.gymchina.tiny.common.global.TinyFrameworkCommandLineRunner;

import javassist.ClassPool;
import javassist.CtClass;
import javassist.LoaderClassPath;
import javassist.bytecode.AnnotationsAttribute;
import javassist.bytecode.ClassFile;
import javassist.bytecode.ConstPool;
import javassist.bytecode.annotation.Annotation;

public class TinyForbiddenAutoDataSourceConfiguration implements TinyFrameworkCommandLineRunner {

	@Override
	@SuppressWarnings({ "unchecked", "rawtypes" })
	public void run(Class<?> primary) throws Exception {
		if (!primary.isAnnotationPresent(SpringBootApplication.class))
			return;
		Object proxyAnnotation = null;
		String fieldName = "exclude";
		if (primary.isAnnotationPresent(EnableAutoConfiguration.class)) {
			proxyAnnotation = primary.getAnnotation(EnableAutoConfiguration.class);
		} else {
			proxyAnnotation = primary.getAnnotation(SpringBootApplication.class);
		}
		InvocationHandler handler = Proxy.getInvocationHandler(proxyAnnotation);
		Field memberValuesField = handler.getClass().getDeclaredField("memberValues");
		memberValuesField.setAccessible(true);
		Map memberValues = (Map) memberValuesField.get(handler);
		Set<Class<?>> packs = new HashSet<>(Arrays.asList((Class<?>[]) memberValues.get(fieldName)));
		if (!packs.contains(DataSourceAutoConfiguration.class))
			packs.add(DataSourceAutoConfiguration.class);
		if (!packs.contains(XADataSourceAutoConfiguration.class))
			packs.add(XADataSourceAutoConfiguration.class);
		Class[] array = {};
		memberValues.put(fieldName, packs.toArray(array));
		
		ClassPool classPool = new ClassPool();
		// get spring class loader
		classPool.insertClassPath(new LoaderClassPath(ClassUtils.getDefaultClassLoader()));
		// make dynamic connection bean
		CtClass configurationClass = classPool.get(primary.getName());
		
		System.out.println("primary : " + primary.hashCode());
		System.out.println("configurationClass : " + configurationClass.toClass().hashCode());
		
		
		ClassFile configurationClassFile = configurationClass.getClassFile();
		ConstPool configurationConstPool = configurationClassFile.getConstPool();

		// add @Configuration Annotation to class
		AnnotationsAttribute attribute = new AnnotationsAttribute(configurationConstPool,
				AnnotationsAttribute.visibleTag);
		Annotation configuration = new Annotation(EnableTransactionManagement.class.getName(), configurationConstPool);
		attribute.addAnnotation(configuration);
		configurationClass.toClass();
	}

}
