/*
 * Decompiled with CFR 0.152.
 */
package com.gymchina.tiny.register.configuration;

import com.gymchina.tiny.common.global.TinyCommon;
import com.gymchina.tiny.register.configuration.TinyForbiddenAutoDataSourceConfiguration;
import com.gymchina.tiny.register.configuration.definition.TinyDataSourceBeanDefinition;
import com.gymchina.tiny.register.configuration.definition.TinySimpleBeanDefinition;
import java.util.ArrayList;
import java.util.List;

public class TinyConfigurationRegistrar {
    private static TinyConfigurationRegistrar _this;
    private List<TinySimpleBeanDefinition> beanDefinitions;
    private int dataSourceBeanDefinitionCnt = 0;

    public static TinyConfigurationRegistrar getInstance() {
        if (null == _this) {
            _this = new TinyConfigurationRegistrar();
            TinyConfigurationRegistrar._this.beanDefinitions = new ArrayList<TinySimpleBeanDefinition>();
        }
        return _this;
    }

    public TinyConfigurationRegistrar addBean(TinySimpleBeanDefinition beanDefinition) {
        this.autoEnableForbiddenDataSourceConfiguration(beanDefinition);
        this.beanDefinitions.add(beanDefinition);
        return this;
    }

    public List<TinySimpleBeanDefinition> getBeanDefinitions() {
        return this.beanDefinitions;
    }

    private void autoEnableForbiddenDataSourceConfiguration(TinySimpleBeanDefinition beanDefinition) {
        if (this.dataSourceBeanDefinitionCnt > 1) {
            return;
        }
        if (TinyDataSourceBeanDefinition.class.isAssignableFrom(beanDefinition.getClass())) {
            ++this.dataSourceBeanDefinitionCnt;
        }
        if (this.dataSourceBeanDefinitionCnt > 1) {
            TinyCommon.tinyFrameworkRunners.add(new TinyForbiddenAutoDataSourceConfiguration());
        }
    }
}

