package com.gymchina.tiny.register.handler;

import java.util.ArrayList;
import java.util.List;

import org.springframework.beans.factory.support.BeanDefinitionRegistry;
import org.springframework.boot.context.properties.bind.Binder;
import org.springframework.context.EnvironmentAware;
import org.springframework.context.annotation.Configuration;
import org.springframework.context.annotation.Import;
import org.springframework.context.annotation.ImportBeanDefinitionRegistrar;
import org.springframework.core.env.Environment;
import org.springframework.core.type.AnnotationMetadata;

import com.gymchina.tiny.register.configuration.TinyConfigurationRegistrar;
import com.gymchina.tiny.register.configuration.definition.TinyDataSourceBeanDefinition;
import com.gymchina.tiny.register.configuration.definition.TinyJedisClusterBeanDefinition;
import com.gymchina.tiny.register.configuration.definition.TinySimpleBeanDefinition;

/**
 * @Title TinySimpleRegisterBeanDefinition
 * @Package com.gymchina.tiny.register.handler
 * @author tangjunfeng
 * @date 2019年3月7日 下午4:15:21
 * @version V1.0
 */
@Configuration
@Import(TinySimpleRegisterBeanDefinition.class)
public class TinySimpleRegisterBeanDefinition implements ImportBeanDefinitionRegistrar, EnvironmentAware {
	
	private static final Class<TinyDataSourceBeanDefinition> datasourceClass = TinyDataSourceBeanDefinition.class;
	private static final Class<TinyJedisClusterBeanDefinition> jedisClass = TinyJedisClusterBeanDefinition.class;
	
	private Binder binder;
	
	@Override
	public void registerBeanDefinitions(AnnotationMetadata importingClassMetadata, BeanDefinitionRegistry registry) {
		TinyConfigurationRegistrar configurationRegistrar = TinyConfigurationRegistrar.getInstance();
		List<TinySimpleBeanDefinition> beanDefinitions = configurationRegistrar.getBeanDefinitions();
		if (null == beanDefinitions || beanDefinitions.isEmpty())
			return;
		List<TinyDataSourceBeanDefinition> dataSources = new ArrayList<>();
		List<TinyJedisClusterBeanDefinition> jedisClusters = new ArrayList<>();
		for (TinySimpleBeanDefinition beanDefinition : beanDefinitions) {
			if (addBeanDefinition(beanDefinition, dataSources, datasourceClass))
				continue;
			addBeanDefinition(beanDefinition, jedisClusters, jedisClass);
		}

		if (!dataSources.isEmpty())
			new TinySimpleDataSourceBeanDefinition(binder).registerDataSources(registry, dataSources);
		if (!jedisClusters.isEmpty())
			new TinySimpleJedisClusterBeanDefinition(binder).registerJedisCluster(registry, jedisClusters);
	}

	@SuppressWarnings("unchecked")
	private <T> boolean addBeanDefinition(TinySimpleBeanDefinition bean, List<T> beans, Class<T> clazz) {
		if (!clazz.isAssignableFrom(bean.getClass()))
			return false;
		beans.add((T) bean);
		return true;
	}

	@Override
	public void setEnvironment(Environment environment) {
		binder = Binder.get(environment);
	}
}
