/*
 * Decompiled with CFR 0.152.
 */
package com.gymchina.tiny.register.handler;

import com.gymchina.tiny.register.configuration.TinyDataSourceBeanDefinition;
import com.gymchina.tiny.register.configuration.TinyRegistrarBeanDefinition;
import java.util.List;
import javassist.CannotCompileException;
import javassist.ClassPath;
import javassist.ClassPool;
import javassist.CtClass;
import javassist.CtMethod;
import javassist.LoaderClassPath;
import javassist.NotFoundException;
import javassist.bytecode.AnnotationsAttribute;
import javassist.bytecode.AttributeInfo;
import javassist.bytecode.ClassFile;
import javassist.bytecode.ConstPool;
import javassist.bytecode.ParameterAnnotationsAttribute;
import javassist.bytecode.annotation.Annotation;
import javassist.bytecode.annotation.ArrayMemberValue;
import javassist.bytecode.annotation.MemberValue;
import javassist.bytecode.annotation.StringMemberValue;
import org.springframework.beans.factory.config.BeanDefinition;
import org.springframework.beans.factory.support.BeanDefinitionRegistry;
import org.springframework.beans.factory.support.GenericBeanDefinition;
import org.springframework.context.annotation.ImportBeanDefinitionRegistrar;
import org.springframework.core.type.AnnotationMetadata;
import org.springframework.util.ClassUtils;

public class TinySimpleRegisterBeanDefinition
implements ImportBeanDefinitionRegistrar {
    private static final String ATOMIKOS = "com.atomikos.jdbc.AtomikosDataSourceBean";
    private static final String NORMAL_BUILDER = "org.springframework.boot.autoconfigure.jdbc.DataSourceBuilder";
    private static final String CONFIGURATION = "org.springframework.context.annotation.Configuration";
    private static final String TRANSACTION_MANAGEMENT = "org.springframework.transaction.annotation.EnableTransactionManagement";
    private static final String PRIMARY = "org.springframework.context.annotation.Primary";
    private static final String BEAN = "org.springframework.context.annotation.Bean";
    private static final String PROPERTIES = "org.springframework.boot.context.properties.ConfigurationProperties";
    private static final String QUALIFIER = "org.springframework.beans.factory.annotation.Qualifier";
    private static final String DATA_SOURCE = "javax.sql.DataSource";
    private static final String DSL_CONTEXT = "org.jooq.DSLContext";
    private static final String JDBCTEMPLATE = "org.springframework.jdbc.core.JdbcTemplate";
    private static final String NAMED_JDBCTEMPLATE = "org.springframework.jdbc.core.namedparam.NamedParameterJdbcTemplate";
    private static final String DYNAMIC_BEAN_NAME = "com.gymchina.tiny.register.TinyAutoDbConnectionConfiguration";

    public void registerBeanDefinitions(AnnotationMetadata importingClassMetadata, BeanDefinitionRegistry registry) {
        TinyRegistrarBeanDefinition beanDefinition = TinyRegistrarBeanDefinition.getInstance();
        List<TinyDataSourceBeanDefinition> beanDefainitions = beanDefinition.getBeanDefainitions();
        if (null == beanDefainitions || beanDefainitions.isEmpty()) {
            return;
        }
        ClassPool classPool = new ClassPool();
        classPool.insertClassPath((ClassPath)new LoaderClassPath(ClassUtils.getDefaultClassLoader()));
        CtClass configurationClass = classPool.makeClass(DYNAMIC_BEAN_NAME);
        ClassFile configurationClassFile = configurationClass.getClassFile();
        ConstPool configurationConstPool = configurationClassFile.getConstPool();
        AnnotationsAttribute attribute = new AnnotationsAttribute(configurationConstPool, "RuntimeVisibleAnnotations");
        Annotation configuration = new Annotation(CONFIGURATION, configurationConstPool);
        attribute.addAnnotation(configuration);
        Annotation transactionManagement = new Annotation(TRANSACTION_MANAGEMENT, configurationConstPool);
        attribute.addAnnotation(transactionManagement);
        configurationClassFile.addAttribute((AttributeInfo)attribute);
        try {
            for (TinyDataSourceBeanDefinition tempBeanDefinition : beanDefainitions) {
                this.makeDataSourceBeanMethod(classPool, configurationConstPool, configurationClass, tempBeanDefinition);
            }
        }
        catch (CannotCompileException | NotFoundException e) {
            e.printStackTrace();
        }
        GenericBeanDefinition genericBeanDefinition = new GenericBeanDefinition();
        try {
            genericBeanDefinition.setBeanClass(configurationClass.toClass());
        }
        catch (CannotCompileException e) {
            e.printStackTrace();
        }
        registry.registerBeanDefinition("tinyAutoDbConnectionConfiguration", (BeanDefinition)genericBeanDefinition);
    }

    private void makeDataSourceBeanMethod(ClassPool classPool, ConstPool constPool, CtClass configurationClass, TinyDataSourceBeanDefinition beanDefinition) throws NotFoundException, CannotCompileException {
        String dataSourceMethodName = beanDefinition.getBeanNamePrefix() + "DataSource";
        StringBuffer methodBody = new StringBuffer();
        methodBody.append("{\n");
        if (beanDefinition.getIsAtomikos().booleanValue()) {
            methodBody.append("return new com.atomikos.jdbc.AtomikosDataSourceBean();\n");
        } else {
            methodBody.append("return org.springframework.boot.autoconfigure.jdbc.DataSourceBuilder.create().build();\n");
        }
        methodBody.append("}");
        this.makeJdbcMethod(classPool, constPool, configurationClass, beanDefinition, DATA_SOURCE, null, methodBody.toString(), "DataSource", dataSourceMethodName, true);
        CtClass[] arguments = this.makeDataSourceArgument(classPool, dataSourceMethodName);
        if (beanDefinition.getJooqCtx().booleanValue()) {
            methodBody.delete(0, methodBody.length());
            methodBody.append("{\n return org.jooq.impl.DSL.using($1, org.jooq.SQLDialect.MYSQL); \n }");
            this.makeJdbcMethod(classPool, constPool, configurationClass, beanDefinition, DSL_CONTEXT, arguments, methodBody.toString(), "Ctx", dataSourceMethodName, false);
        }
        if (beanDefinition.getJdbctemplate().booleanValue()) {
            methodBody.delete(0, methodBody.length());
            methodBody.append("{\n return new org.springframework.jdbc.core.JdbcTemplate($1);\n }");
            this.makeJdbcMethod(classPool, constPool, configurationClass, beanDefinition, JDBCTEMPLATE, arguments, methodBody.toString(), "JdbcTemplate", dataSourceMethodName, false);
        }
        if (beanDefinition.getNamedJdbctemplate().booleanValue()) {
            methodBody.delete(0, methodBody.length());
            methodBody.append("{\n return new org.springframework.jdbc.core.namedparam.NamedParameterJdbcTemplate($1);\n }");
            this.makeJdbcMethod(classPool, constPool, configurationClass, beanDefinition, NAMED_JDBCTEMPLATE, arguments, methodBody.toString(), "NamedParameterJdbcTemplate", dataSourceMethodName, false);
        }
    }

    private void makeJdbcMethod(ClassPool classPool, ConstPool constPool, CtClass beanClass, TinyDataSourceBeanDefinition beanDefinition, String returnClass, CtClass[] arguments, String methodBody, String nameSuffix, String dataSourceName, boolean isConfigurationProperties) throws NotFoundException, CannotCompileException {
        String methodName = beanDefinition.getBeanNamePrefix() + nameSuffix;
        CtClass returnCtClass = classPool.get(returnClass);
        CtMethod dataSourceMethod = new CtMethod(returnCtClass, methodName, arguments, beanClass);
        dataSourceMethod.setModifiers(1);
        dataSourceMethod.setBody(methodBody);
        AnnotationsAttribute attribute = new AnnotationsAttribute(constPool, "RuntimeVisibleAnnotations");
        if (beanDefinition.getPrimary().booleanValue() && isConfigurationProperties) {
            attribute.addAnnotation(new Annotation(PRIMARY, constPool));
        }
        Annotation beanAnnotation = new Annotation(BEAN, constPool);
        ArrayMemberValue beanNames = new ArrayMemberValue(constPool);
        StringMemberValue[] memberValues = new StringMemberValue[]{new StringMemberValue(methodName, constPool)};
        beanNames.setValue((MemberValue[])memberValues);
        beanAnnotation.addMemberValue("name", (MemberValue)beanNames);
        attribute.addAnnotation(beanAnnotation);
        if (isConfigurationProperties) {
            Annotation properties = new Annotation(PROPERTIES, constPool);
            properties.addMemberValue("prefix", (MemberValue)new StringMemberValue(beanDefinition.getPropertiesPrefix(), constPool));
            attribute.addAnnotation(properties);
        }
        dataSourceMethod.getMethodInfo().addAttribute((AttributeInfo)attribute);
        if (!isConfigurationProperties) {
            ParameterAnnotationsAttribute parameterAttribute = new ParameterAnnotationsAttribute(constPool, "RuntimeVisibleParameterAnnotations");
            Annotation qualifier = new Annotation(QUALIFIER, constPool);
            qualifier.addMemberValue("value", (MemberValue)new StringMemberValue(dataSourceName, constPool));
            Annotation[][] paramArrays = new Annotation[1][1];
            paramArrays[0][0] = qualifier;
            parameterAttribute.setAnnotations(paramArrays);
            dataSourceMethod.getMethodInfo().addAttribute((AttributeInfo)parameterAttribute);
        }
        beanClass.addMethod(dataSourceMethod);
    }

    private CtClass[] makeDataSourceArgument(ClassPool classPool, String dataSourceName) throws NotFoundException {
        return new CtClass[]{classPool.get(DATA_SOURCE)};
    }
}

