package com.gymchina.tiny.register.configuration;

import java.util.ArrayList;
import java.util.List;

/**
 * @Title TinyRegistrarBeanDefinition
 * @Package com.gymchina.tiny.register.configuration
 * @author tangjunfeng
 * @date 2019年3月7日 下午4:25:55
 * @version V1.0
 */
public class TinyRegistrarBeanDefinition {

	private static TinyRegistrarBeanDefinition _this;
	private Class<?> primary;

	public static TinyRegistrarBeanDefinition getInstance(Class<?> primary) {
		if (null == _this) {
			if (null == primary)
				throw new NullPointerException("Cannot found primary class");
			_this = new TinyRegistrarBeanDefinition();
			_this.beanDefainitions = new ArrayList<>();
			_this.primary = primary;
		}
		return _this;
	}

	public static TinyRegistrarBeanDefinition getInstance() {
		return getInstance(null);
	}

	private List<TinyDataSourceBeanDefinition> beanDefainitions;

	public TinyRegistrarBeanDefinition addBean(TinyDataSourceBeanDefinition beanDefinition) {
		beanDefainitions.add(beanDefinition);
		return this;
	}

	public List<TinyDataSourceBeanDefinition> getBeanDefainitions() {
		return beanDefainitions;
	}

	public Class<?> getPrimary() {
		return primary;
	}

}
