package com.gymchina.tiny.register.handler;

import java.lang.reflect.Field;
import java.lang.reflect.InvocationHandler;
import java.lang.reflect.Proxy;
import java.util.Arrays;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;

import org.springframework.boot.autoconfigure.EnableAutoConfiguration;
import org.springframework.boot.autoconfigure.SpringBootApplication;
import org.springframework.boot.autoconfigure.jdbc.DataSourceAutoConfiguration;
import org.springframework.boot.autoconfigure.jdbc.XADataSourceAutoConfiguration;

public class TinyForbiddenAutoDataSourceConfiguration {

	@SuppressWarnings({ "unchecked", "rawtypes" })
	public static void execute(Class<?> primary) throws Exception {
		if (!primary.isAnnotationPresent(SpringBootApplication.class))
			return;
		Object proxyAnnotation = null;
		String fieldName = "exclude";
		if (primary.isAnnotationPresent(EnableAutoConfiguration.class)) {
			proxyAnnotation = primary.getAnnotation(EnableAutoConfiguration.class);
		} else {
			proxyAnnotation = primary.getAnnotation(SpringBootApplication.class);
		}
		InvocationHandler handler = Proxy.getInvocationHandler(proxyAnnotation);
		Field memberValuesField = handler.getClass().getDeclaredField("memberValues");
		memberValuesField.setAccessible(true);
		Map memberValues = (Map) memberValuesField.get(handler);
		Set<Class<?>> packs = new HashSet<>(Arrays.asList((Class<?>[]) memberValues.get(fieldName)));
		if (!packs.contains(DataSourceAutoConfiguration.class))
			packs.add(DataSourceAutoConfiguration.class);
		if (!packs.contains(XADataSourceAutoConfiguration.class))
			packs.add(XADataSourceAutoConfiguration.class);
		Class[] array = {};
		memberValues.put(fieldName, packs.toArray(array));
	}

}
