package com.gymchina.tiny.register.configuration;

import java.util.ArrayList;
import java.util.List;

/**
 * @Title TinyRegistrarBeanDefinition
 * @Package com.gymchina.tiny.register.configuration
 * @author tangjunfeng
 * @date 2019年3月7日 下午4:25:55
 * @version V1.0
 */
public class TinyRegistrarBeanDefinition {

	private static TinyRegistrarBeanDefinition _this;

	public static TinyRegistrarBeanDefinition getInstance() {
		if (null == _this) {
			_this = new TinyRegistrarBeanDefinition();
			_this.beanDefainitions = new ArrayList<>();
		}
		return _this;
	}

	private List<TinyDataSourceBeanDefinition> beanDefainitions;

	public TinyRegistrarBeanDefinition addBean(TinyDataSourceBeanDefinition beanDefinition) {
		beanDefainitions.add(beanDefinition);
		return this;
	}

	public List<TinyDataSourceBeanDefinition> getBeanDefainitions() {
		return beanDefainitions;
	}

}
