package com.gymchina.tiny.register.configuration;

public class TinyDataSourceBeanDefinition {

	private String beanNamePrefix;
	private String propertiesPrefix;
	private Boolean primary;
	private Boolean isAtomikos;
	private Boolean jooqCtx;
	private Boolean jdbctemplate;
	private Boolean namedJdbctemplate;

	public static TinyDataSourceBeanDefinition of(String beanNamePrefix, String propertiesPrefix, boolean primary,
			boolean isAtomikos, boolean jooqCtx, boolean jdbctemplate, boolean namedJdbctemplate) {
		return new TinyDataSourceBeanDefinition().setBeanNamePrefix(beanNamePrefix)
				.setPropertiesPrefix(propertiesPrefix).setPrimary(primary).setIsAtomikos(isAtomikos).setJooqCtx(jooqCtx)
				.setJdbctemplate(jdbctemplate).setNamedJdbctemplate(namedJdbctemplate);
	}

	public static TinyDataSourceBeanDefinition of(String beanNamePrefix, String propertiesPrefix, boolean primary,
			boolean isAtomikos) {
		return of(beanNamePrefix, propertiesPrefix, primary, isAtomikos, true, true, true);
	}

	public static TinyDataSourceBeanDefinition of(String beanNamePrefix, String propertiesPrefix, boolean isAtomikos) {
		return of(beanNamePrefix, propertiesPrefix, false, isAtomikos);
	}

	public String getBeanNamePrefix() {
		return beanNamePrefix;
	}

	public TinyDataSourceBeanDefinition setBeanNamePrefix(String beanNamePrefix) {
		this.beanNamePrefix = beanNamePrefix;
		return this;
	}

	public String getPropertiesPrefix() {
		return propertiesPrefix;
	}

	public TinyDataSourceBeanDefinition setPropertiesPrefix(String propertiesPrefix) {
		this.propertiesPrefix = propertiesPrefix;
		return this;
	}

	public Boolean getPrimary() {
		return primary;
	}

	public TinyDataSourceBeanDefinition setPrimary(Boolean primary) {
		this.primary = primary;
		return this;
	}

	public Boolean getIsAtomikos() {
		return isAtomikos;
	}

	public TinyDataSourceBeanDefinition setIsAtomikos(Boolean isAtomikos) {
		this.isAtomikos = isAtomikos;
		return this;
	}

	public Boolean getJooqCtx() {
		return jooqCtx;
	}

	public TinyDataSourceBeanDefinition setJooqCtx(Boolean jooqCtx) {
		this.jooqCtx = jooqCtx;
		return this;
	}

	public Boolean getJdbctemplate() {
		return jdbctemplate;
	}

	public TinyDataSourceBeanDefinition setJdbctemplate(Boolean jdbctemplate) {
		this.jdbctemplate = jdbctemplate;
		return this;
	}

	public Boolean getNamedJdbctemplate() {
		return namedJdbctemplate;
	}

	public TinyDataSourceBeanDefinition setNamedJdbctemplate(Boolean namedJdbctemplate) {
		this.namedJdbctemplate = namedJdbctemplate;
		return this;
	}

}