package com.gymchina.tiny.mvc.filters;

import java.io.IOException;
import java.util.Enumeration;

import javax.servlet.Filter;
import javax.servlet.FilterChain;
import javax.servlet.FilterConfig;
import javax.servlet.ServletException;
import javax.servlet.ServletRequest;
import javax.servlet.ServletResponse;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;

import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class TinyMvcHttpRequestLogger implements Filter {

	private static Logger logger = LoggerFactory.getLogger(TinyMvcHttpRequestLogger.class);

	private static boolean showRequestUrl = true;

	public TinyMvcHttpRequestLogger() {
		super();
	}

	public TinyMvcHttpRequestLogger(boolean showRequestUrl) {
		super();
		TinyMvcHttpRequestLogger.showRequestUrl = showRequestUrl;
	}

	@Override
	public void init(FilterConfig filterConfig) throws ServletException {
	}

	@Override
	public void doFilter(ServletRequest request, ServletResponse response, FilterChain chain)
			throws IOException, ServletException {
		HttpServletRequest httpRequest = (HttpServletRequest) request;
		HttpServletResponse httpResponse = (HttpServletResponse) response;
		long startTimestamp = System.currentTimeMillis();
		StringBuffer sb = null;
		if (showRequestUrl) {
			sb = new StringBuffer(httpRequest.getMethod()).append(" ");
			sb.append(httpRequest.getRequestURI()).append("?");

			Enumeration<String> names = request.getParameterNames();
			String element = null;
			while (names.hasMoreElements()) {
				element = names.nextElement();
				sb.append(element).append("=").append(request.getParameter(element)).append("&");
			}
			sb.delete(sb.length() - 1, sb.length()).append(" - ");
		}

		int status = 0;
		try {
			chain.doFilter(httpRequest, httpResponse);
			status = httpResponse.getStatus();
		} catch (Throwable e) {
			status = 500;
			throw e;
		} finally {
			this.loggerRequestInfo(sb, startTimestamp, status, httpResponse);
		}
	}

	@Override
	public void destroy() {
	}

	private void loggerRequestInfo(StringBuffer sb, long startTimestamp, int status, HttpServletResponse httpResponse) {
		if (!showRequestUrl)
			return;
		sb.append(httpResponse.getContentType()).append(" ");
		sb.append(status).append(" - ");

		long timestamp = System.currentTimeMillis() - startTimestamp;
		sb.append("Timer : ").append(timestamp).append("ms");
		// 超过3秒则不写入info
		logger.info(sb.toString());
		if (timestamp > 3000) {
			logger.warn(sb.toString());
		}
	}
}
