package com.gymchina.tiny.mvc.resolver;

import org.springframework.core.MethodParameter;
import org.springframework.core.ResolvableType;
import org.springframework.web.bind.annotation.RequestParam;
import org.springframework.web.context.request.NativeWebRequest;
import org.springframework.web.method.annotation.RequestParamMethodArgumentResolver;

import com.google.gson.Gson;
import com.google.gson.GsonBuilder;

/**
 * @Title TinyParamJsonArgumentResolver
 * @Package com.gymchina.tiny.mvc.resolver
 * @author tangjunfeng
 * @date 2019年5月5日 下午12:10:55
 * @version V1.0
 */
public class TinyParamJsonArgumentResolver extends RequestParamMethodArgumentResolver {

	private static Gson GSON = new GsonBuilder().disableHtmlEscaping().create();

	public TinyParamJsonArgumentResolver() {
		super(false);
	}

	@Override
	public boolean supportsParameter(MethodParameter parameter) {
		return parameter.hasParameterAnnotation(TinyParamJson.class)
				&& parameter.hasParameterAnnotation(RequestParam.class);
	}

	@Override
	protected Object resolveName(String name, MethodParameter parameter, NativeWebRequest request) throws Exception {
		String value = request.getParameter(name);
		if (null == value || "".equals(value.trim()))
			return null;
		ResolvableType resolvableType = ResolvableType.forMethodParameter(parameter);
		return GSON.fromJson(value, resolvableType.getType());
	}
}
