/*
 * Decompiled with CFR 0.152.
 */
package com.gymchina.tiny.mvc.resolver;

import com.google.gson.Gson;
import com.google.gson.GsonBuilder;
import com.gymchina.tiny.mvc.resolver.TinyParamJson;
import org.springframework.core.MethodParameter;
import org.springframework.core.ResolvableType;
import org.springframework.web.bind.annotation.RequestParam;
import org.springframework.web.context.request.NativeWebRequest;
import org.springframework.web.method.annotation.RequestParamMethodArgumentResolver;

public class TinyParamJsonArgumentResolver
extends RequestParamMethodArgumentResolver {
    private static Gson GSON = new GsonBuilder().disableHtmlEscaping().create();

    public TinyParamJsonArgumentResolver() {
        super(false);
    }

    public boolean supportsParameter(MethodParameter parameter) {
        return parameter.hasParameterAnnotation(TinyParamJson.class) && parameter.hasParameterAnnotation(RequestParam.class);
    }

    protected Object resolveName(String name, MethodParameter parameter, NativeWebRequest request) throws Exception {
        String value = request.getParameter(name);
        if (null == value || "".equals(value.trim())) {
            return null;
        }
        ResolvableType resolvableType = ResolvableType.forMethodParameter((MethodParameter)parameter);
        return GSON.fromJson(value, resolvableType.getType());
    }
}

