/*
 * Decompiled with CFR 0.152.
 */
package com.gymchina.tiny.mvc.configuration;

import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.databind.ObjectMapper;
import org.springframework.boot.web.server.ErrorPage;
import org.springframework.boot.web.server.ErrorPageRegistrar;
import org.springframework.boot.web.server.ErrorPageRegistry;
import org.springframework.context.annotation.Bean;
import org.springframework.context.annotation.Configuration;
import org.springframework.http.HttpStatus;
import org.springframework.http.converter.json.MappingJackson2HttpMessageConverter;

@Configuration
public class WebApplicationMvcRegistryConfig
implements ErrorPageRegistrar {
    @Bean
    public MappingJackson2HttpMessageConverter mappingJackson2HttpMessageConverter(ObjectMapper objectMapper) {
        objectMapper.setSerializationInclusion(JsonInclude.Include.NON_NULL);
        return new MappingJackson2HttpMessageConverter(objectMapper);
    }

    public void registerErrorPages(ErrorPageRegistry registry) {
        ErrorPage _400 = new ErrorPage(HttpStatus.BAD_REQUEST, "/400");
        ErrorPage _404 = new ErrorPage(HttpStatus.NOT_FOUND, "/404");
        ErrorPage _405 = new ErrorPage(HttpStatus.METHOD_NOT_ALLOWED, "/405");
        ErrorPage _500 = new ErrorPage(HttpStatus.INTERNAL_SERVER_ERROR, "/500");
        registry.addErrorPages(new ErrorPage[]{_400, _404, _405, _500});
    }
}

