package com.gymchina.tiny.mvc.configuration;

import java.util.ArrayList;
import java.util.List;

import javax.annotation.PostConstruct;

import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.context.annotation.Configuration;
import org.springframework.web.method.support.HandlerMethodArgumentResolver;
import org.springframework.web.servlet.mvc.method.annotation.RequestMappingHandlerAdapter;

import com.gymchina.tiny.mvc.resolver.TinyParamJsonArgumentResolver;

@Configuration
public class TinyMvcRequestParamAdapter {

	private static Logger logger = LoggerFactory.getLogger(TinyMvcRequestParamAdapter.class);

	@Autowired
	private RequestMappingHandlerAdapter requestMappingHandlerAdapter;

	@PostConstruct
	public void addTinyArgumentResolvers() {
		logger.info("Invocation tiny mvc request param argument resolver finished");
		List<HandlerMethodArgumentResolver> resolvers = new ArrayList<>();
		resolvers.addAll(requestMappingHandlerAdapter.getArgumentResolvers());
		resolvers.add(0, new TinyParamJsonArgumentResolver());
		requestMappingHandlerAdapter.setArgumentResolvers(resolvers);
	}

}
