package com.gymchina.tiny.mvc.errors;

import javax.servlet.http.HttpServletRequest;

import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Value;
import org.springframework.http.HttpStatus;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RestController;

/**
 * @Title HttpServletBaseErrorController.java
 * @Package com.waqu.web.mvc.common.controller
 * @author tangjunfeng
 * @date 2017年5月4日 下午2:26:20
 * @version V1.0
 */
@RestController
public class HttpServletBaseErrorController {

	@Value("${http.servlet.error.message.enabled:true}")
	private boolean enabled;

	@Autowired
	private HttpServletErrorAttributes httpServletErrorAttributes;

	@RequestMapping(HttpServletBaseErrorUri._400)
	public String _400(HttpServletRequest request) {
		return printErrorMessageEnabled(request, HttpStatus.BAD_REQUEST);
	}

	@RequestMapping(HttpServletBaseErrorUri._404)
	public String _404() {
		return toJson(HttpStatus.NOT_FOUND);
	}

	@RequestMapping(HttpServletBaseErrorUri._405)
	public String _405() {
		return toJson(HttpStatus.METHOD_NOT_ALLOWED);
	}

	@RequestMapping(HttpServletBaseErrorUri._500)
	public String _500(HttpServletRequest request) {
		return printErrorMessageEnabled(request, HttpStatus.INTERNAL_SERVER_ERROR);
	}

	private String toJson(HttpStatus status, String... msg) {
		if (null != msg && msg.length > 0 && null != msg[0])
			return "{\"status\":" + status.value() + ", \"msg\":\"" + msg[0] + "\"}";
		return "{\"status\":" + status.value() + ", \"msg\":\"" + status.getReasonPhrase() + "\"}";
	}

	private String printErrorMessageEnabled(HttpServletRequest request, HttpStatus status) {
		if (!enabled)
			return toJson(status);
		String message = httpServletErrorAttributes.getErrorMessage(request);
		if (null != message && message.indexOf("\"") >= 0)
			message = message.replace("\"", "\\\"");
		return toJson(status, message);
	}
}