/*
 * Decompiled with CFR 0.152.
 */
package com.gymchina.tiny.mvc.configuration;

import com.gymchina.tiny.mvc.filters.TinyMvcHttpRequestLogger;
import javax.servlet.Filter;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Value;
import org.springframework.boot.web.servlet.FilterRegistrationBean;
import org.springframework.context.annotation.Bean;
import org.springframework.context.annotation.Configuration;

@Configuration
public class FilterRegistryConfig {
    private static Logger logger = LoggerFactory.getLogger(FilterRegistryConfig.class);
    @Value(value="${mvc.show.request.url:true}")
    private boolean showRequestUrl;

    @Bean
    public FilterRegistrationBean<TinyMvcHttpRequestLogger> httpServletAccessFilter() {
        logger.info("Invocation TinyMvcHttpRequestLogFilter Finish");
        logger.info("Spring Boot Show Request Url Service : {}", (Object)(this.showRequestUrl ? "ON" : "OFF"));
        FilterRegistrationBean registrationBean = new FilterRegistrationBean();
        registrationBean.setFilter((Filter)new TinyMvcHttpRequestLogger(this.showRequestUrl));
        registrationBean.setOrder(-1);
        registrationBean.setName("tinyMvcHttpRequestLogFilter");
        registrationBean.addUrlPatterns(new String[]{"/*"});
        return registrationBean;
    }
}

