package com.gymchina.tiny.mvc.configuration;

import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Value;
import org.springframework.boot.web.servlet.FilterRegistrationBean;
import org.springframework.context.annotation.Bean;
import org.springframework.context.annotation.Configuration;

import com.gymchina.tiny.mvc.filters.TinyMvcHttpRequestLogger;

@Configuration
public class FilterRegistryConfig {

	private static Logger logger = LoggerFactory.getLogger(FilterRegistryConfig.class);

	@Value("${mvc.show.request.url:true}")
	private boolean showRequestUrl;

	@Bean
	public FilterRegistrationBean<TinyMvcHttpRequestLogger> httpServletAccessFilter() {
		logger.info("Invocation TinyMvcHttpRequestLogFilter Finish");
		logger.info("Spring Boot Show Request Url Service : {}", showRequestUrl ? "ON" : "OFF");
		FilterRegistrationBean<TinyMvcHttpRequestLogger> registrationBean = new FilterRegistrationBean<>();
		registrationBean.setFilter(new TinyMvcHttpRequestLogger(showRequestUrl));
		registrationBean.setOrder(-1);
		registrationBean.setName("tinyMvcHttpRequestLogFilter");
		registrationBean.addUrlPatterns("/*");
		return registrationBean;
	}

}
