package com.gymchina.tiny.mvc.other;

import java.io.PrintStream;

import org.springframework.boot.Banner;
import org.springframework.boot.ansi.AnsiOutput;
import org.springframework.core.env.Environment;

public class TinyBanner implements Banner {

	private static final String[] BANNER = {"            精          \n" + 
			"            精中\n" + 
			"            精中\n" + 
			"            精中精中精中      \n" + 
			"         精中精中精中精中精中    \n" + 
			"       精中精中精中精中精中精中  \n" + 
			"   精中精中精中精中    精中精中 \n" + 
			"  精中精中    精中     精中精中 \n" + 
			"   精中      精中     精中中  \n" + 
			"   精中      精中     精中   \n" + 
			"   精中      精中    精中    \n" + 
			"    精中     精中精中精中     \n" + 
			"    精中   精中精中精中精中    \n" + 
			"     精中精中精中精中精中中    \n" + 
			"      精中精中精中精中          \n" + 
			"      中    精中             \n" + 
			"            精中             \n" + 
			"            精中             \n" + 
			"            精中             \n" + 
			"            精中             \n" + 
			"            精中\n" + 
			"            中"};

	private static final String SPRING_BOOT = " :: Mvc For Tiny Framework :: ";

	private static final int STRAP_LINE_SIZE = 42;

	@Override
	public void printBanner(Environment environment, Class<?> sourceClass, PrintStream out) {
		for (String line : BANNER) {
			out.println(line);
		}
		String version = Banner.class.getPackage().getImplementationVersion();
		version = (version == null ? "" : " (v" + version + ")");
		String padding = "";
		while (padding.length() < STRAP_LINE_SIZE - (version.length() + SPRING_BOOT.length())) {
			padding += " ";
		}

		out.println(AnsiOutput.toString(SPRING_BOOT, padding, version));
		out.println();
	}
}
