package com.gymchina.tiny.mvc.configuration;

import org.springframework.boot.web.server.ErrorPage;
import org.springframework.boot.web.server.ErrorPageRegistrar;
import org.springframework.boot.web.server.ErrorPageRegistry;
import org.springframework.context.annotation.Bean;
import org.springframework.context.annotation.Configuration;
import org.springframework.http.HttpStatus;
import org.springframework.http.converter.json.MappingJackson2HttpMessageConverter;

import com.fasterxml.jackson.annotation.JsonInclude.Include;
import com.fasterxml.jackson.databind.ObjectMapper;
import com.gymchina.tiny.mvc.errors.HttpServletBaseErrorUri;

@Configuration
public class WebApplicationMvcRegistryConfig implements ErrorPageRegistrar {
	
	@Bean
	public MappingJackson2HttpMessageConverter mappingJackson2HttpMessageConverter(ObjectMapper objectMapper) {
		objectMapper.setSerializationInclusion(Include.NON_NULL);
		return new MappingJackson2HttpMessageConverter(objectMapper);
	}

	@Override
	public void registerErrorPages(ErrorPageRegistry registry) {
		ErrorPage _400 = new ErrorPage(HttpStatus.BAD_REQUEST, HttpServletBaseErrorUri._400);
		ErrorPage _404 = new ErrorPage(HttpStatus.NOT_FOUND, HttpServletBaseErrorUri._404);
		ErrorPage _405 = new ErrorPage(HttpStatus.METHOD_NOT_ALLOWED, HttpServletBaseErrorUri._405);
		ErrorPage _500 = new ErrorPage(HttpStatus.INTERNAL_SERVER_ERROR, HttpServletBaseErrorUri._500);
		registry.addErrorPages(_400, _404, _405, _500);
	}

}
