/*
 * Decompiled with CFR 0.152.
 */
package com.gymchina.android.common.utils;

import android.annotation.SuppressLint;
import android.content.Context;
import android.content.SharedPreferences;
import com.gymchina.android.common.App;
import com.gymchina.android.common.utils.StringUtil;

public final class SpUtil {
    public static final String DEF_SP_FILE_NAME = "def_sp_file";

    private static String getSPName(Object object) {
        return DEF_SP_FILE_NAME;
    }

    private static String getSPKey(String preFix, String key) {
        if (StringUtil.isNull(preFix)) {
            return key;
        }
        return preFix + "_" + key;
    }

    public static String getDefStringPrefs(Context context, String key, String defaultValue) {
        return SpUtil.getExpandStringPrefs(context, null, null, key, defaultValue);
    }

    public static void saveDefStringPrefs(Context context, String key, String value) {
        SpUtil.saveExpandStringPrefs(context, null, null, key, value, true);
    }

    public static long getDefLongPrefs(Context context, String key, long defaultValue) {
        return SpUtil.getExpandLongPrefs(context, null, null, key, defaultValue);
    }

    public static void saveDefLongPrefs(Context context, String key, long value) {
        SpUtil.saveExpandLongPrefs(context, null, null, key, value, true);
    }

    public static boolean getDefBooleanPrefs(Context context, String key, boolean defaultValue) {
        return SpUtil.getExpandBooleanPrefs(context, null, null, key, defaultValue);
    }

    public static void saveDefBooleanPrefs(Context context, String key, boolean value) {
        SpUtil.saveExpandBooleanPrefs(context, null, null, key, value, true);
    }

    public static int getDefIntPrefs(Context context, String key, int defaultValue) {
        return SpUtil.getExpandIntPrefs(context, null, null, key, defaultValue);
    }

    public static void saveDefIntPrefs(Context context, String key, int value) {
        SpUtil.saveExpandIntPrefs(context, null, null, key, value, true);
    }

    public static String getExpandStringPrefs(Context context, Object object, String preFix, String key, String defaultValue) {
        return SpUtil.getStringPrefs(context, SpUtil.getSPName(object), SpUtil.getSPKey(preFix, key), defaultValue);
    }

    public static void saveExpandStringPrefs(Context context, Object object, String preFix, String key, String value, boolean sync) {
        SpUtil.saveStringPrefs(context, SpUtil.getSPName(object), SpUtil.getSPKey(preFix, key), value, sync);
    }

    public static long getExpandLongPrefs(Context context, Object object, String preFix, String key, long defaultValue) {
        return SpUtil.getLongPrefs(context, SpUtil.getSPName(object), SpUtil.getSPKey(preFix, key), defaultValue);
    }

    public static void saveExpandLongPrefs(Context context, Object object, String preFix, String key, long value, boolean sync) {
        SpUtil.saveLongPrefs(context, SpUtil.getSPName(object), SpUtil.getSPKey(preFix, key), value, sync);
    }

    public static boolean getExpandBooleanPrefs(Context context, Object object, String preFix, String key, boolean defaultValue) {
        return SpUtil.getBooleanPrefs(context, SpUtil.getSPName(object), SpUtil.getSPKey(preFix, key), defaultValue);
    }

    public static void saveExpandBooleanPrefs(Context context, Object object, String preFix, String key, boolean value, boolean sync) {
        SpUtil.saveBooleanPrefs(context, SpUtil.getSPName(object), SpUtil.getSPKey(preFix, key), value, sync);
    }

    public static int getExpandIntPrefs(Context context, Object object, String preFix, String key, int defaultValue) {
        return SpUtil.getIntPrefs(context, SpUtil.getSPName(object), SpUtil.getSPKey(preFix, key), defaultValue);
    }

    public static void saveExpandIntPrefs(Context context, Object object, String preFix, String key, int value, boolean sync) {
        SpUtil.saveIntPrefs(context, SpUtil.getSPName(object), SpUtil.getSPKey(preFix, key), value, sync);
    }

    public static String getStringPrefs(Context context, String spFileName, String key, String defaultValue) {
        if (context == null) {
            context = App.instance();
        }
        return context.getSharedPreferences(spFileName, 0).getString(key, defaultValue);
    }

    @SuppressLint(value={"ApplySharedPref"})
    public static void saveStringPrefs(Context context, String spFileName, String key, String value, boolean sync) {
        if (context == null) {
            context = App.instance();
        }
        SharedPreferences.Editor editor = context.getSharedPreferences(spFileName, 0).edit();
        editor.putString(key, value);
        if (sync) {
            editor.commit();
        } else {
            editor.apply();
        }
    }

    public static long getLongPrefs(Context context, String spFileName, String key, long defaultValue) {
        if (context == null) {
            context = App.instance();
        }
        return context.getSharedPreferences(spFileName, 0).getLong(key, defaultValue);
    }

    @SuppressLint(value={"ApplySharedPref"})
    public static void saveLongPrefs(Context context, String spFileName, String key, long value, boolean sync) {
        if (context == null) {
            context = App.instance();
        }
        SharedPreferences.Editor editor = context.getSharedPreferences(spFileName, 0).edit();
        editor.putLong(key, value);
        if (sync) {
            editor.commit();
        } else {
            editor.apply();
        }
    }

    public static boolean getBooleanPrefs(Context context, String spFileName, String key, boolean defaultValue) {
        if (context == null) {
            context = App.instance();
        }
        return context.getSharedPreferences(spFileName, 0).getBoolean(key, defaultValue);
    }

    @SuppressLint(value={"ApplySharedPref"})
    public static void saveBooleanPrefs(Context context, String spFileName, String key, boolean value, boolean sync) {
        if (context == null) {
            context = App.instance();
        }
        SharedPreferences.Editor editor = context.getSharedPreferences(spFileName, 0).edit();
        editor.putBoolean(key, value);
        if (sync) {
            editor.commit();
        } else {
            editor.apply();
        }
    }

    public static int getIntPrefs(Context context, String spFileName, String key, int defaultValue) {
        if (context == null) {
            context = App.instance();
        }
        return context.getSharedPreferences(spFileName, 0).getInt(key, defaultValue);
    }

    @SuppressLint(value={"ApplySharedPref"})
    public static void saveIntPrefs(Context context, String spFileName, String key, int value, boolean sync) {
        if (context == null) {
            context = App.instance();
        }
        SharedPreferences.Editor editor = context.getSharedPreferences(spFileName, 0).edit();
        editor.putInt(key, value);
        if (sync) {
            editor.commit();
        } else {
            editor.apply();
        }
    }
}

