/*
 * Decompiled with CFR 0.152.
 */
package com.gymchina.android.agentweb;

import android.animation.Animator;
import android.animation.AnimatorListenerAdapter;
import android.animation.AnimatorSet;
import android.animation.ObjectAnimator;
import android.animation.TimeInterpolator;
import android.animation.ValueAnimator;
import android.content.Context;
import android.graphics.Canvas;
import android.graphics.Color;
import android.graphics.Paint;
import android.support.annotation.Nullable;
import android.util.AttributeSet;
import android.view.View;
import android.view.animation.DecelerateInterpolator;
import android.view.animation.LinearInterpolator;
import android.widget.FrameLayout;
import com.gymchina.android.agentweb.AgentWebUtils;
import com.gymchina.android.agentweb.BaseIndicatorSpec;
import com.gymchina.android.agentweb.BaseIndicatorView;
import com.gymchina.android.agentweb.LogUtils;

public class WebIndicator
extends BaseIndicatorView
implements BaseIndicatorSpec {
    private int mColor;
    private Paint mPaint;
    private Animator mAnimator;
    private int mTargetWidth = 0;
    public static final int MAX_UNIFORM_SPEED_DURATION = 8000;
    public static final int MAX_DECELERATE_SPEED_DURATION = 450;
    public static final int DO_END_ANIMATION_DURATION = 600;
    private static int CURRENT_MAX_UNIFORM_SPEED_DURATION = 8000;
    private static int CURRENT_MAX_DECELERATE_SPEED_DURATION = 450;
    private int TAG = 0;
    public static final int UN_START = 0;
    public static final int STARTED = 1;
    public static final int FINISH = 2;
    private float mTarget = 0.0f;
    private float mCurrentProgress = 0.0f;
    public static int WEB_INDICATOR_DEFAULT_HEIGHT = 3;
    private ValueAnimator.AnimatorUpdateListener mAnimatorUpdateListener = new ValueAnimator.AnimatorUpdateListener(){

        public void onAnimationUpdate(ValueAnimator animation) {
            float t = ((Float)animation.getAnimatedValue()).floatValue();
            WebIndicator.this.mCurrentProgress = t;
            WebIndicator.this.invalidate();
        }
    };
    private AnimatorListenerAdapter mAnimatorListenerAdapter = new AnimatorListenerAdapter(){

        public void onAnimationEnd(Animator animation) {
            WebIndicator.this.doEnd();
        }
    };

    public WebIndicator(Context context) {
        this(context, null);
    }

    public WebIndicator(Context context, @Nullable AttributeSet attrs) {
        this(context, attrs, 0);
    }

    public WebIndicator(Context context, @Nullable AttributeSet attrs, int defStyleAttr) {
        super(context, attrs, defStyleAttr);
        this.init(context, attrs, defStyleAttr);
    }

    private void init(Context context, AttributeSet attrs, int defStyleAttr) {
        this.mPaint = new Paint();
        this.mColor = Color.parseColor((String)"#1aad19");
        this.mPaint.setAntiAlias(true);
        this.mPaint.setColor(this.mColor);
        this.mPaint.setDither(true);
        this.mPaint.setStrokeCap(Paint.Cap.SQUARE);
        this.mTargetWidth = context.getResources().getDisplayMetrics().widthPixels;
        WEB_INDICATOR_DEFAULT_HEIGHT = AgentWebUtils.dp2px(context, 3.0f);
    }

    public void setColor(int color2) {
        this.mColor = color2;
        this.mPaint.setColor(color2);
    }

    public void setColor(String color2) {
        this.setColor(Color.parseColor((String)color2));
    }

    protected void onMeasure(int widthMeasureSpec, int heightMeasureSpec) {
        int wMode = View.MeasureSpec.getMode((int)widthMeasureSpec);
        int w = View.MeasureSpec.getSize((int)widthMeasureSpec);
        int hMode = View.MeasureSpec.getMode((int)heightMeasureSpec);
        int h = View.MeasureSpec.getSize((int)heightMeasureSpec);
        if (wMode == Integer.MIN_VALUE) {
            int n = w = w <= this.getContext().getResources().getDisplayMetrics().widthPixels ? w : this.getContext().getResources().getDisplayMetrics().widthPixels;
        }
        if (hMode == Integer.MIN_VALUE) {
            h = WEB_INDICATOR_DEFAULT_HEIGHT;
        }
        this.setMeasuredDimension(w, h);
    }

    protected void onDraw(Canvas canvas) {
    }

    protected void dispatchDraw(Canvas canvas) {
        canvas.drawRect(0.0f, 0.0f, this.mCurrentProgress / 100.0f * Float.valueOf(this.getWidth()).floatValue(), (float)this.getHeight(), this.mPaint);
    }

    @Override
    public void show() {
        if (this.getVisibility() == 8) {
            this.setVisibility(0);
            this.mCurrentProgress = 0.0f;
            this.startAnim(false);
        }
    }

    protected void onSizeChanged(int w, int h, int oldw, int oldh) {
        super.onSizeChanged(w, h, oldw, oldh);
        this.mTargetWidth = this.getMeasuredWidth();
        int screenWidth = this.getContext().getResources().getDisplayMetrics().widthPixels;
        if (this.mTargetWidth >= screenWidth) {
            CURRENT_MAX_DECELERATE_SPEED_DURATION = 450;
            CURRENT_MAX_UNIFORM_SPEED_DURATION = 8000;
        } else {
            float rate = (float)this.mTargetWidth / Float.valueOf(screenWidth).floatValue();
            CURRENT_MAX_UNIFORM_SPEED_DURATION = (int)(8000.0f * rate);
            CURRENT_MAX_DECELERATE_SPEED_DURATION = (int)(450.0f * rate);
        }
        LogUtils.i("WebProgress", "CURRENT_MAX_UNIFORM_SPEED_DURATION" + CURRENT_MAX_UNIFORM_SPEED_DURATION);
    }

    public void setProgress(float progress) {
        if (this.getVisibility() == 8) {
            this.setVisibility(0);
        }
        if (progress < 95.0f) {
            return;
        }
        if (this.TAG != 2) {
            this.startAnim(true);
        }
    }

    @Override
    public void hide() {
        this.TAG = 2;
    }

    private void startAnim(boolean isFinished) {
        float v;
        float f = v = isFinished ? 100.0f : 95.0f;
        if (this.mAnimator != null && this.mAnimator.isStarted()) {
            this.mAnimator.cancel();
        }
        this.mCurrentProgress = this.mCurrentProgress == 0.0f ? 1.0E-8f : this.mCurrentProgress;
        LogUtils.i("WebIndicator", "mCurrentProgress:" + this.mCurrentProgress + " v:" + v + "  :" + (1.0f - this.mCurrentProgress));
        if (!isFinished) {
            ValueAnimator mAnimator = ValueAnimator.ofFloat((float[])new float[]{this.mCurrentProgress, v});
            float residue = 1.0f - this.mCurrentProgress / 100.0f - 0.05f;
            mAnimator.setInterpolator((TimeInterpolator)new LinearInterpolator());
            mAnimator.setDuration((long)(residue * (float)CURRENT_MAX_UNIFORM_SPEED_DURATION));
            mAnimator.addUpdateListener(this.mAnimatorUpdateListener);
            mAnimator.start();
            this.mAnimator = mAnimator;
        } else {
            ValueAnimator segment95Animator = null;
            if (this.mCurrentProgress < 95.0f) {
                segment95Animator = ValueAnimator.ofFloat((float[])new float[]{this.mCurrentProgress, 95.0f});
                float residue = 1.0f - this.mCurrentProgress / 100.0f - 0.05f;
                segment95Animator.setInterpolator((TimeInterpolator)new LinearInterpolator());
                segment95Animator.setDuration((long)(residue * (float)CURRENT_MAX_DECELERATE_SPEED_DURATION));
                segment95Animator.setInterpolator((TimeInterpolator)new DecelerateInterpolator());
                segment95Animator.addUpdateListener(this.mAnimatorUpdateListener);
            }
            ObjectAnimator mObjectAnimator = ObjectAnimator.ofFloat((Object)this, (String)"alpha", (float[])new float[]{1.0f, 0.0f});
            mObjectAnimator.setDuration(600L);
            ValueAnimator mValueAnimatorEnd = ValueAnimator.ofFloat((float[])new float[]{95.0f, 100.0f});
            mValueAnimatorEnd.setDuration(600L);
            mValueAnimatorEnd.addUpdateListener(this.mAnimatorUpdateListener);
            AnimatorSet mAnimatorSet = new AnimatorSet();
            mAnimatorSet.playTogether(new Animator[]{mObjectAnimator, mValueAnimatorEnd});
            if (segment95Animator != null) {
                AnimatorSet mAnimatorSet1 = new AnimatorSet();
                mAnimatorSet1.play((Animator)mAnimatorSet).after((Animator)segment95Animator);
                mAnimatorSet = mAnimatorSet1;
            }
            mAnimatorSet.addListener((Animator.AnimatorListener)this.mAnimatorListenerAdapter);
            mAnimatorSet.start();
            this.mAnimator = mAnimatorSet;
        }
        this.TAG = 1;
        this.mTarget = v;
    }

    protected void onDetachedFromWindow() {
        super.onDetachedFromWindow();
        if (this.mAnimator != null && this.mAnimator.isStarted()) {
            this.mAnimator.cancel();
            this.mAnimator = null;
        }
    }

    private void doEnd() {
        if (this.TAG == 2 && this.mCurrentProgress == 100.0f) {
            this.setVisibility(8);
            this.mCurrentProgress = 0.0f;
            this.setAlpha(1.0f);
        }
        this.TAG = 0;
    }

    @Override
    public void reset() {
        this.mCurrentProgress = 0.0f;
        if (this.mAnimator != null && this.mAnimator.isStarted()) {
            this.mAnimator.cancel();
        }
    }

    @Override
    public void setProgress(int newProgress) {
        this.setProgress(Float.valueOf(newProgress).floatValue());
    }

    public FrameLayout.LayoutParams offerLayoutParams() {
        return new FrameLayout.LayoutParams(-1, WEB_INDICATOR_DEFAULT_HEIGHT);
    }
}

