/*
 * Decompiled with CFR 0.152.
 */
package com.gymchina.android.agentweb;

import android.annotation.TargetApi;
import android.content.Context;
import android.graphics.Bitmap;
import android.os.Build;
import android.util.AttributeSet;
import android.util.Log;
import android.util.Pair;
import android.view.ViewGroup;
import android.view.ViewParent;
import android.view.accessibility.AccessibilityManager;
import android.webkit.JsPromptResult;
import android.webkit.WebBackForwardList;
import android.webkit.WebChromeClient;
import android.webkit.WebView;
import android.webkit.WebViewClient;
import android.widget.Toast;
import com.gymchina.android.agentweb.JsCallJava;
import com.gymchina.android.agentweb.LogUtils;
import com.gymchina.android.agentweb.MiddlewareWebChromeBase;
import com.gymchina.android.agentweb.MiddlewareWebClientBase;
import java.lang.reflect.Field;
import java.lang.reflect.Method;
import java.net.URI;
import java.net.URLEncoder;
import java.util.HashMap;
import java.util.Map;
import org.json.JSONObject;

public class AgentWebView
extends WebView {
    private static final String TAG = AgentWebView.class.getSimpleName();
    private Map<String, JsCallJava> mJsCallJavas;
    private Map<String, String> mInjectJavaScripts;
    private FixedOnReceivedTitle mFixedOnReceivedTitle;
    private boolean mIsInited;
    private Boolean mIsAccessibilityEnabledOriginal;

    public AgentWebView(Context context) {
        this(context, null);
    }

    public AgentWebView(Context context, AttributeSet attrs) {
        super(context, attrs);
        this.removeSearchBoxJavaBridge();
        this.mIsInited = true;
        this.mFixedOnReceivedTitle = new FixedOnReceivedTitle();
    }

    @Deprecated
    public final void addJavascriptInterface(Object interfaceObj, String interfaceName) {
        if (Build.VERSION.SDK_INT >= 17) {
            super.addJavascriptInterface(interfaceObj, interfaceName);
            Log.i((String)TAG, (String)"\u6ce8\u5165");
            return;
        }
        Log.i((String)TAG, (String)("use mJsCallJavas:" + interfaceName));
        LogUtils.i(TAG, "addJavascriptInterface:" + interfaceObj + "   interfaceName:" + interfaceName);
        if (this.mJsCallJavas == null) {
            this.mJsCallJavas = new HashMap<String, JsCallJava>();
        }
        this.mJsCallJavas.put(interfaceName, new JsCallJava(interfaceObj, interfaceName));
        this.injectJavaScript();
        if (LogUtils.isDebug()) {
            Log.d((String)TAG, (String)("injectJavaScript, addJavascriptInterface.interfaceObj = " + interfaceObj + ", interfaceName = " + interfaceName));
        }
        this.addJavascriptInterfaceSupport(interfaceObj, interfaceName);
    }

    protected void addJavascriptInterfaceSupport(Object interfaceObj, String interfaceName) {
    }

    public final void setWebChromeClient(WebChromeClient client) {
        AgentWebChrome mAgentWebChrome = new AgentWebChrome(this);
        mAgentWebChrome.setDelegate(client);
        this.mFixedOnReceivedTitle.setWebChromeClient(client);
        super.setWebChromeClient((WebChromeClient)mAgentWebChrome);
        this.setWebChromeClientSupport(mAgentWebChrome);
    }

    protected final void setWebChromeClientSupport(WebChromeClient client) {
    }

    public final void setWebViewClient(WebViewClient client) {
        AgentWebClient mAgentWebClient = new AgentWebClient(this);
        mAgentWebClient.setDelegate(client);
        super.setWebViewClient((WebViewClient)mAgentWebClient);
        this.setWebViewClientSupport(mAgentWebClient);
    }

    public final void setWebViewClientSupport(WebViewClient client) {
    }

    public void destroy() {
        this.setVisibility(8);
        if (this.mJsCallJavas != null) {
            this.mJsCallJavas.clear();
        }
        if (this.mInjectJavaScripts != null) {
            this.mInjectJavaScripts.clear();
        }
        this.removeAllViewsInLayout();
        this.fixedStillAttached();
        this.releaseConfigCallback();
        if (this.mIsInited) {
            this.resetAccessibilityEnabled();
            LogUtils.i(TAG, "destroy web");
            super.destroy();
        }
    }

    public void clearHistory() {
        if (this.mIsInited) {
            super.clearHistory();
        }
    }

    public static Pair<Boolean, String> isWebViewPackageException(Throwable e) {
        String messageCause = e.getCause() == null ? e.toString() : e.getCause().toString();
        String trace = Log.getStackTraceString((Throwable)e);
        if (trace.contains("android.content.pm.PackageManager$NameNotFoundException") || trace.contains("java.lang.RuntimeException: Cannot load WebView") || trace.contains("android.webkit.WebViewFactory$MissingWebViewPackageException: Failed to load WebView provider: No WebView installed")) {
            LogUtils.safeCheckCrash(TAG, "isWebViewPackageException", e);
            return new Pair((Object)true, (Object)("WebView load failed, " + messageCause));
        }
        return new Pair((Object)false, (Object)messageCause);
    }

    public void setOverScrollMode(int mode) {
        try {
            super.setOverScrollMode(mode);
        }
        catch (Throwable e) {
            Pair<Boolean, String> pair = AgentWebView.isWebViewPackageException(e);
            if (((Boolean)pair.first).booleanValue()) {
                Toast.makeText((Context)this.getContext(), (CharSequence)((CharSequence)pair.second), (int)0).show();
                this.destroy();
            }
            throw e;
        }
    }

    public boolean isPrivateBrowsingEnabled() {
        if (Build.VERSION.SDK_INT == 15 && this.getSettings() == null) {
            return false;
        }
        return super.isPrivateBrowsingEnabled();
    }

    public void addInjectJavaScript(String javaScript) {
        if (this.mInjectJavaScripts == null) {
            this.mInjectJavaScripts = new HashMap<String, String>();
        }
        this.mInjectJavaScripts.put(String.valueOf(javaScript.hashCode()), javaScript);
        this.injectExtraJavaScript();
    }

    private void injectJavaScript() {
        for (Map.Entry<String, JsCallJava> entry : this.mJsCallJavas.entrySet()) {
            this.loadUrl(this.buildNotRepeatInjectJS(entry.getKey(), entry.getValue().getPreloadInterfaceJs()));
        }
    }

    private void injectExtraJavaScript() {
        for (Map.Entry<String, String> entry : this.mInjectJavaScripts.entrySet()) {
            this.loadUrl(this.buildNotRepeatInjectJS(entry.getKey(), entry.getValue()));
        }
    }

    public String buildNotRepeatInjectJS(String key, String js) {
        String obj = String.format("__injectFlag_%1$s__", key);
        StringBuilder sb = new StringBuilder();
        sb.append("javascript:try{(function(){if(window.");
        sb.append(obj);
        sb.append("){console.log('");
        sb.append(obj);
        sb.append(" has been injected');return;}window.");
        sb.append(obj);
        sb.append("=true;");
        sb.append(js);
        sb.append("}())}catch(e){console.warn(e)}");
        return sb.toString();
    }

    public String buildTryCatchInjectJS(String js) {
        StringBuilder sb = new StringBuilder();
        sb.append("javascript:try{");
        sb.append(js);
        sb.append("}catch(e){console.warn(e)}");
        return sb.toString();
    }

    private void fixedStillAttached() {
        ViewParent parent = this.getParent();
        if (parent instanceof ViewGroup) {
            ViewGroup mWebViewContainer = (ViewGroup)this.getParent();
            mWebViewContainer.removeAllViewsInLayout();
        }
    }

    private void releaseConfigCallback() {
        block14: {
            if (Build.VERSION.SDK_INT < 16) {
                try {
                    Field field = WebView.class.getDeclaredField("mWebViewCore");
                    field = field.getType().getDeclaredField("mBrowserFrame");
                    field = field.getType().getDeclaredField("sConfigCallback");
                    field.setAccessible(true);
                    field.set(null, null);
                }
                catch (NoSuchFieldException e) {
                    if (LogUtils.isDebug()) {
                        e.printStackTrace();
                    }
                    break block14;
                }
                catch (IllegalAccessException e) {
                    if (LogUtils.isDebug()) {
                        e.printStackTrace();
                    }
                    break block14;
                }
            }
            if (Build.VERSION.SDK_INT < 19) {
                try {
                    Field sConfigCallback = Class.forName("android.webkit.BrowserFrame").getDeclaredField("sConfigCallback");
                    if (sConfigCallback != null) {
                        sConfigCallback.setAccessible(true);
                        sConfigCallback.set(null, null);
                    }
                }
                catch (NoSuchFieldException e) {
                    if (LogUtils.isDebug()) {
                        e.printStackTrace();
                    }
                }
                catch (ClassNotFoundException e) {
                    if (LogUtils.isDebug()) {
                        e.printStackTrace();
                    }
                }
                catch (IllegalAccessException e) {
                    if (!LogUtils.isDebug()) break block14;
                    e.printStackTrace();
                }
            }
        }
    }

    @TargetApi(value=19)
    protected void trySetWebDebuggEnabled() {
        block3: {
            if (LogUtils.isDebug() && Build.VERSION.SDK_INT >= 19) {
                try {
                    Class<WebView> clazz = WebView.class;
                    Method method = clazz.getMethod("setWebContentsDebuggingEnabled", Boolean.TYPE);
                    method.invoke(null, true);
                }
                catch (Throwable e) {
                    if (!LogUtils.isDebug()) break block3;
                    e.printStackTrace();
                }
            }
        }
    }

    @TargetApi(value=11)
    protected boolean removeSearchBoxJavaBridge() {
        block3: {
            try {
                if (Build.VERSION.SDK_INT >= 11 && Build.VERSION.SDK_INT < 17) {
                    Method method = ((Object)((Object)this)).getClass().getMethod("removeJavascriptInterface", String.class);
                    method.invoke((Object)this, "searchBoxJavaBridge_");
                    return true;
                }
            }
            catch (Exception e) {
                if (!LogUtils.isDebug()) break block3;
                e.printStackTrace();
            }
        }
        return false;
    }

    protected void fixedAccessibilityInjectorException() {
        if (Build.VERSION.SDK_INT == 17 && this.mIsAccessibilityEnabledOriginal == null && this.isAccessibilityEnabled()) {
            this.mIsAccessibilityEnabledOriginal = true;
            this.setAccessibilityEnabled(false);
        }
    }

    protected void fixedAccessibilityInjectorExceptionForOnPageFinished(String url) {
        block6: {
            if (Build.VERSION.SDK_INT == 16 && this.getSettings().getJavaScriptEnabled() && this.mIsAccessibilityEnabledOriginal == null && this.isAccessibilityEnabled()) {
                try {
                    try {
                        URLEncoder.encode(String.valueOf(new URI(url)), "utf-8");
                    }
                    catch (IllegalArgumentException e) {
                        if ("bad parameter".equals(e.getMessage())) {
                            this.mIsAccessibilityEnabledOriginal = true;
                            this.setAccessibilityEnabled(false);
                            LogUtils.safeCheckCrash(TAG, "fixedAccessibilityInjectorExceptionForOnPageFinished.url = " + url, e);
                        }
                    }
                }
                catch (Throwable e) {
                    if (!LogUtils.isDebug()) break block6;
                    LogUtils.e(TAG, "fixedAccessibilityInjectorExceptionForOnPageFinished", e);
                }
            }
        }
    }

    private boolean isAccessibilityEnabled() {
        AccessibilityManager am = (AccessibilityManager)this.getContext().getSystemService("accessibility");
        return am.isEnabled();
    }

    private void setAccessibilityEnabled(boolean enabled) {
        block2: {
            AccessibilityManager am = (AccessibilityManager)this.getContext().getSystemService("accessibility");
            try {
                Method setAccessibilityState = am.getClass().getDeclaredMethod("setAccessibilityState", Boolean.TYPE);
                setAccessibilityState.setAccessible(true);
                setAccessibilityState.invoke((Object)am, enabled);
                setAccessibilityState.setAccessible(false);
            }
            catch (Throwable e) {
                if (!LogUtils.isDebug()) break block2;
                LogUtils.e(TAG, "setAccessibilityEnabled", e);
            }
        }
    }

    private void resetAccessibilityEnabled() {
        if (this.mIsAccessibilityEnabledOriginal != null) {
            this.setAccessibilityEnabled(this.mIsAccessibilityEnabledOriginal);
        }
    }

    private static class FixedOnReceivedTitle {
        private WebChromeClient mWebChromeClient;
        private boolean mIsOnReceivedTitle;

        private FixedOnReceivedTitle() {
        }

        public void setWebChromeClient(WebChromeClient webChromeClient) {
            this.mWebChromeClient = webChromeClient;
        }

        public void onPageStarted() {
            this.mIsOnReceivedTitle = false;
        }

        public void onPageFinished(WebView view) {
            if (!this.mIsOnReceivedTitle && this.mWebChromeClient != null) {
                WebBackForwardList list;
                block4: {
                    list = null;
                    try {
                        list = view.copyBackForwardList();
                    }
                    catch (NullPointerException e) {
                        if (!LogUtils.isDebug()) break block4;
                        e.printStackTrace();
                    }
                }
                if (list != null && list.getSize() > 0 && list.getCurrentIndex() >= 0 && list.getItemAtIndex(list.getCurrentIndex()) != null) {
                    String previousTitle = list.getItemAtIndex(list.getCurrentIndex()).getTitle();
                    this.mWebChromeClient.onReceivedTitle(view, previousTitle);
                }
            }
        }

        public void onReceivedTitle() {
            this.mIsOnReceivedTitle = true;
        }
    }

    public static class AgentWebChrome
    extends MiddlewareWebChromeBase {
        private AgentWebView mAgentWebView;

        private AgentWebChrome(AgentWebView agentWebView) {
            this.mAgentWebView = agentWebView;
        }

        @Override
        public void onReceivedTitle(WebView view, String title) {
            this.mAgentWebView.mFixedOnReceivedTitle.onReceivedTitle();
            super.onReceivedTitle(view, title);
        }

        @Override
        public void onProgressChanged(WebView view, int newProgress) {
            if (this.mAgentWebView.mJsCallJavas != null) {
                this.mAgentWebView.injectJavaScript();
                if (LogUtils.isDebug()) {
                    Log.d((String)TAG, (String)("injectJavaScript, onProgressChanged.newProgress = " + newProgress + ", url = " + view.getUrl()));
                }
            }
            if (this.mAgentWebView.mInjectJavaScripts != null) {
                this.mAgentWebView.injectExtraJavaScript();
            }
            super.onProgressChanged(view, newProgress);
        }

        @Override
        public boolean onJsPrompt(WebView view, String url, String message, String defaultValue, JsPromptResult result) {
            Log.i((String)TAG, (String)("onJsPrompt:" + url + "  message:" + message + "  d:" + defaultValue + "  "));
            if (this.mAgentWebView.mJsCallJavas != null && JsCallJava.isSafeWebViewCallMsg(message)) {
                JsCallJava mJsCallJava;
                JSONObject jsonObject = JsCallJava.getMsgJSONObject(message);
                String interfacedName = JsCallJava.getInterfacedName(jsonObject);
                if (interfacedName != null && (mJsCallJava = (JsCallJava)this.mAgentWebView.mJsCallJavas.get(interfacedName)) != null) {
                    result.confirm(mJsCallJava.call(view, jsonObject));
                }
                return true;
            }
            return super.onJsPrompt(view, url, message, defaultValue, result);
        }
    }

    public static class AgentWebClient
    extends MiddlewareWebClientBase {
        private AgentWebView mAgentWebView;

        private AgentWebClient(AgentWebView agentWebView) {
            this.mAgentWebView = agentWebView;
        }

        @Override
        public void onPageStarted(WebView view, String url, Bitmap favicon) {
            super.onPageStarted(view, url, favicon);
            if (this.mAgentWebView.mJsCallJavas != null) {
                this.mAgentWebView.injectJavaScript();
                if (LogUtils.isDebug()) {
                    Log.d((String)TAG, (String)("injectJavaScript, onPageStarted.url = " + view.getUrl()));
                }
            }
            if (this.mAgentWebView.mInjectJavaScripts != null) {
                this.mAgentWebView.injectExtraJavaScript();
            }
            this.mAgentWebView.mFixedOnReceivedTitle.onPageStarted();
            this.mAgentWebView.fixedAccessibilityInjectorExceptionForOnPageFinished(url);
        }

        @Override
        public void onPageFinished(WebView view, String url) {
            super.onPageFinished(view, url);
            this.mAgentWebView.mFixedOnReceivedTitle.onPageFinished(view);
            if (LogUtils.isDebug()) {
                Log.d((String)TAG, (String)("onPageFinished.url = " + view.getUrl()));
            }
        }
    }
}

