package com.baidubce.services.vpn.model;

import com.baidubce.auth.BceCredentials;
import com.baidubce.model.AbstractBceRequest;
import com.fasterxml.jackson.annotation.JsonIgnore;
import lombok.Getter;
import lombok.Setter;
import lombok.experimental.Accessors;

import java.util.List;

@Setter
@Getter
@Accessors(chain = true)
public class UpdateSslVpnServerRequest extends AbstractBceRequest {
    /**
     * An ASCII string whose length is less than 64.
     * <p>
     * The request will be idempotent if clientToken is provided.
     * If the clientToken is not specified by the user, a random String generated by default algorithm will be used.
     * See more detail at
     * <a href = "https://bce.baidu.com/doc/BCC/API.html#.E5.B9.82.E7.AD.89.E6.80.A7">
     * BCE API doc</a>
     */
    @JsonIgnore
    private String clientToken;

    /*********************** Required **************************/
    /**vpnId*/
    private String vpnId;

    /*********************** Required **************************/
    /**sslVpnServerId*/
    private String sslVpnServerId;

    /**
     * SSL-VPN server name.
     */
    private String sslVpnServerName;

    /**
     * Local network CIDR list
     */
    private List<String> localSubnets;

    /**
     * Client network CIDR
     */
    private String remoteSubnet;

    /**
     * Client's DNS addresses
     */
    private String clientDns;

    @Override
    public AbstractBceRequest withRequestCredentials(BceCredentials credentials) {
        this.setRequestCredentials(credentials);
        return this;
    }

    @Override
    public void setRequestCredentials(BceCredentials credentials) {
        super.setRequestCredentials(credentials);
    }
}
