package com.baidubce.services.peerconn.model;

import com.baidubce.auth.BceCredentials;
import com.baidubce.model.AbstractBceRequest;
import com.fasterxml.jackson.annotation.JsonIgnore;

/**
 * The request for switch a peer connection delete protect.
 */
public class SwitchPeerConnDeleteProtectRequest extends AbstractBceRequest {
    /**
     * An ASCII string whose length is less than 64.
     *
     * The request will be idempotent if clientToken is provided.
     * If the clientToken is not specified by the user, a random String generated by default algorithm will be used.
     * See more detail at
     * <a href = "https://bce.baidu.com/doc/BCC/API.html#.E5.B9.82.E7.AD.89.E6.80.A7">
     *     BCE API doc</a>
     */
    @JsonIgnore
    private String clientToken;

    /**
     * The peerConnId of peer conn.
     */
    @JsonIgnore
    private String peerConnId;

    /**
     * The delete protect switch of peer conn.
     */
    private Boolean deleteProtect;

    @Override
    public AbstractBceRequest withRequestCredentials(BceCredentials credentials) {
        this.setRequestCredentials(credentials);
        return this;
    }

    public String getClientToken() {
        return clientToken;
    }

    public void setClientToken(String clientToken) {
        this.clientToken = clientToken;
    }

    public String getPeerConnId() {
        return peerConnId;
    }

    public void setPeerConnId(String peerConnId) {
        this.peerConnId = peerConnId;
    }

    public Boolean getDeleteProtect() {
        return deleteProtect;
    }

    public void setDeleteProtect(Boolean deleteProtect) {
        this.deleteProtect = deleteProtect;
    }
}
