/*
 * Copyright (C) 2020 Baidu, Inc. All Rights Reserved.
 *
 * Licensed under the Apache License, Version 2.0 (the "License"); you may not use this file except in compliance with
 * the License. You may obtain a copy of the License at
 *
 * http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software distributed under the License is distributed on
 * an "AS IS" BASIS, WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied. See the License for the
 * specific language governing permissions and limitations under the License.
 */
package com.baidubce.services.iotdmp.model.bie.protocol;

import com.baidubce.model.GenericAccountRequest;
import com.fasterxml.jackson.annotation.JsonInclude;
import lombok.AllArgsConstructor;
import lombok.Builder;
import lombok.Data;
import lombok.NoArgsConstructor;

import java.util.List;
import java.util.Map;

@Data
@Builder
@NoArgsConstructor
@AllArgsConstructor
@JsonInclude(JsonInclude.Include.NON_NULL)
public class BusinessTemplatesAppRequest extends GenericAccountRequest {
    private String name;
    private String description = "";
    private String selector;
    private String version;
    private String createTime;
    private Map<String, String> labels;
    private List<BusinessTemplatesAppService> services;
    private List<BusinessTemplatesAppService> initServices;
    private List<BusinessTemplatesAppRegistry> registries;
    private List<BusinessTemplatesAppVolume> volumes;
    @Builder.Default
    private BieWorkload workload = BieWorkload.deployment;
    @Builder.Default
    private BieAppType type = BieAppType.container;
    @Builder.Default
    private BieMode mode = BieMode.kube;
    @Builder.Default
    private int replica = 1;
}
