package com.baidubce.services.eiptp.model;

import com.baidubce.auth.BceCredentials;
import com.baidubce.model.AbstractBceRequest;
import com.fasterxml.jackson.annotation.JsonIgnore;
import lombok.Getter;
import lombok.Setter;

/**
 * The request for creating a new eipTp.
 */
@Setter
@Getter
public class CreateEipTpRequest extends AbstractBceRequest {
    /**
     * If the clientToken is not specified by the user, a random String generated by default algorithm will be used.
     * See more detail at
     * <a href = "https://bce.baidu.com/doc/EIP/API.html#.E9.80.9A.E7.94.A8.E8.AF.B4.E6.98.8E">
     * BCE API doc</a>
     */
    @JsonIgnore
    private String clientToken;
    /**
     * The reservation length of the eiptp including 1, 6 and 12 months.
     */
    private Integer reservationLength;

    /**
     * The capacity of the eiptp.
     * When reservationLength = 1 => capacity: {"10G"/"50G"/"100G"/"500G"/"1T"/"5T"/"10T"/"50T"}
     * When reservationLength = 6 => capacity: {"60G"/"300G"/"600G"/"3T"/"6T"/"30T"/"60T"/"300T"}
     * When reservationLength = 12 => capacity: {"1T"/"10T"/"50T"/"100T"/"500T"/"1P"}
     */
    private String capacity;

    /**
     * The deduct policy of the eiptp including "FullTimeDurationPackage" and "TimeDurationPackage".
     * The default deduct policy is "FullTimeDurationPackage", the optional parameter.
     */
    private String deductPolicy;

    /**
     * The eiptp package type.
     * The default package type is "WebOutBytes", the optional parameter.
     */
    private String packageType;

    @Override
    public CreateEipTpRequest withRequestCredentials(BceCredentials credentials) {
        this.setRequestCredentials(credentials);
        return this;
    }
}
