/*
 * Copyright (C) 2016 Baidu, Inc. All Rights Reserved.
 */
package com.baidubce.services.eip.model;

import com.baidubce.auth.BceCredentials;
import com.baidubce.model.AbstractBceRequest;
import com.fasterxml.jackson.annotation.JsonIgnore;
import lombok.Getter;
import lombok.Setter;

/**
 * The request for stop autoRenew
 */
@Getter
@Setter

public class DirectEipRequest extends AbstractBceRequest {
    /**
     * If the clientToken is not specified by the user, a random String generated by default algorithm will be used.
     * See more detail at
     * <a href = "https://bce.baidu.com/doc/EIP/API.html#.E9.80.9A.E7.94.A8.E8.AF.B4.E6.98.8E">
     * BCE API doc</a>
     */
    @JsonIgnore
    private String clientToken;
    /**
     * eip address to be stopped autoRenew
     */
    @JsonIgnore
    private String eip;

    public DirectEipRequest withClientToken(String clientToken) {
        this.clientToken = clientToken;
        return this;
    }

    public DirectEipRequest withEip(String eip) {
        this.eip = eip;
        return this;
    }

    public DirectEipRequest withRequestCredentials(BceCredentials credentials) {
        this.setRequestCredentials(credentials);
        return this;
    }
}
