/*
 * Copyright (c) 2020 Baidu.com, Inc. All Rights Reserved
 *
 * Licensed under the Apache License, Version 2.0 (the "License"); you may not use this file except in compliance with
 * the License. You may obtain a copy of the License at
 *
 * http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software distributed under the License is distributed on
 * an "AS IS" BASIS, WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied. See the License for the
 * specific language governing permissions and limitations under the License.
 */
package com.baidubce.services.bec.model.blb;

import com.baidubce.auth.BceCredentials;
import com.baidubce.model.AbstractBceRequest;
import com.baidubce.services.bec.model.enums.ServiceProviderEnum;
import com.baidubce.services.tag.model.Tag;
import com.fasterxml.jackson.annotation.JsonIgnore;
import lombok.Builder;
import lombok.Data;

import java.util.List;

/**
 * The request for creating BEC blb.
 * Shared with blb and app blb creation.
 */
@Data
@Builder
public class CreateBecBlbRequest extends AbstractBceRequest {

    /**
     * Load balance type.
     */
    private String lbType;

    /**
     * The payment method of the blb.
     */
    private String paymentMethod;

    /**
     * The name of the blb.
     */
    private String blbName;

    /**
     * Region selection.
     */
    private String regionSelection;

    /**
     * The region of the blb.
     */
    private String region;

    /**
     * The city of the blb.
     */
    private String city;

    /**
     * The serviceProvider of the blb.
     */
    private ServiceProviderEnum serviceProvider;

    /**
     * The region id of the blb.
     */
    private String regionId;

    /**
     * The need for public IP.
     */
    private Boolean needPublicIp;

    /**
     * Load balancing maximum bandwidth limit, 1 - 20000 Mbps.
     */
    private Integer bandwidthInMbpsLimit;

    /**
     * tags.
     */
    private List<Tag> tags;

    /**
     * The network type, bec network type must be [classic|vpc], default classic.
     */
    private String networkType;

    /**
     * The vpc id.
     */
    private String vpcId;

    /**
     * The subnet id.
     */
    private String subnetId;

    /**
     * The subServiceProvider of the blb, intra represent inner net, [ct,un,cm,intra].
     */
    protected List<String> subServiceProviders;

    /**
     * Whether the blb need public ipv6.
     */
    private Boolean needIpv6PublicIp;

    /**
     * An ASCII string whose length is less than 64.
     * <p>
     * The request will be idempotent if clientToken is provided.
     * If the clientToken is not specified by the user, a random String generated by default algorithm will be used.
     * See more detail at
     * <a href = "https://bce.baidu.com/doc/BEC/API.html">
     * BCE API doc</a>
     */
    @JsonIgnore
    private String clientToken;

    /**
     * Configure request credential for the request.
     *
     * @param credentials a valid instance of BceCredentials.
     * @return CreateBecBlbRequest with credentials.
     */
    public CreateBecBlbRequest withRequestCredentials(BceCredentials credentials) {
        this.setRequestCredentials(credentials);
        return this;
    }
}
