/*
 * Decompiled with CFR 0.152.
 */
package com.android.gymchina.framework.utils;

import android.annotation.TargetApi;
import android.app.Activity;
import android.content.Context;
import android.graphics.Rect;
import android.os.Build;
import android.view.DisplayCutout;
import android.view.View;
import android.view.WindowManager;
import com.android.gymchina.framework.base.Application;
import com.android.gymchina.framework.utils.RomUtils;
import com.android.gymchina.framework.utils.ScreenUtil;
import com.android.gymchina.framework.utils.SpUtil;
import com.android.gymchina.framework.utils.StringUtil;
import com.android.gymchina.framework.utils.SystemPropertiesProxy;
import java.lang.reflect.Method;
import java.util.List;

public class NotchUtil {
    private static final String DEVICES_HAS_NOTCH_KEY = "devices_has_notch";
    public static final int VIVO_NOTCH = 32;
    public static final int VIVO_FILLET = 8;

    private NotchUtil() {
        throw new UnsupportedOperationException("cannot be instantiated");
    }

    public static void setShowNotch(Activity activity) {
        if (!NotchUtil.hasNotch(activity)) {
            return;
        }
        if (Build.VERSION.SDK_INT >= 28) {
            WindowManager.LayoutParams lp = activity.getWindow().getAttributes();
            lp.layoutInDisplayCutoutMode = 1;
            activity.getWindow().setAttributes(lp);
        }
    }

    public static boolean hasNotch(Activity activity) {
        boolean hasNotch = false;
        String deviceId = SpUtil.getStringPrefs((Context)Application.instance(), "device_info", DEVICES_HAS_NOTCH_KEY, "");
        if (StringUtil.isNotNull(deviceId)) {
            hasNotch = Boolean.parseBoolean(deviceId);
        } else if (Build.VERSION.SDK_INT >= 28) {
            List<Rect> rectList = NotchUtil.getBoundingRects(activity);
            hasNotch = rectList != null && rectList.size() > 0;
        } else if (Build.VERSION.SDK_INT >= 26) {
            hasNotch = RomUtils.checkIsHuaweiRom() ? NotchUtil.hasNotchAtHuawei((Context)activity) : (RomUtils.checkIsVivoRom() ? NotchUtil.hasNotchAtVivo((Context)activity) : (RomUtils.checkIsOppoRom() ? NotchUtil.hasNotchAtOppo((Context)activity) : (RomUtils.checkIsMiuiRom() ? NotchUtil.hasNotchAtXiaomi((Context)activity) : NotchUtil.hasNotchAtHuawei((Context)activity) || NotchUtil.hasNotchAtVivo((Context)activity) || NotchUtil.hasNotchAtOppo((Context)activity) || NotchUtil.hasNotchAtXiaomi((Context)activity))));
        }
        SpUtil.saveStringPrefs((Context)Application.instance(), "device_info", DEVICES_HAS_NOTCH_KEY, String.valueOf(hasNotch), true);
        return hasNotch;
    }

    public static int[] getNotchSize(Activity activity) {
        if (NotchUtil.hasNotch(activity)) {
            if (RomUtils.checkIsHuaweiRom()) {
                return NotchUtil.getNotchSizeAtHuawei((Context)activity);
            }
            if (RomUtils.checkIsVivoRom()) {
                return NotchUtil.getNotchSizeAtVivo((Context)activity);
            }
            if (RomUtils.checkIsOppoRom()) {
                return NotchUtil.getNotchSizeAtOppo();
            }
            if (RomUtils.checkIsMiuiRom()) {
                return NotchUtil.getNotchSizeAtXiaomi((Context)activity);
            }
            return new int[]{0, ScreenUtil.getStatusBarHeight((Context)activity)};
        }
        return new int[]{0, 0};
    }

    @TargetApi(value=28)
    public static List<Rect> getBoundingRects(Activity activity) {
        try {
            View decorView = activity.getWindow().getDecorView();
            DisplayCutout displayCutout = decorView.getRootWindowInsets().getDisplayCutout();
            return displayCutout.getBoundingRects();
        }
        catch (Exception exception) {
            return null;
        }
    }

    @TargetApi(value=28)
    public static int getSafeInsetLeft(Activity activity) {
        try {
            View decorView = activity.getWindow().getDecorView();
            DisplayCutout displayCutout = decorView.getRootWindowInsets().getDisplayCutout();
            return displayCutout.getSafeInsetLeft();
        }
        catch (Exception exception) {
            return -1;
        }
    }

    @TargetApi(value=28)
    public static int getSafeInsetTop(Activity activity) {
        try {
            View decorView = activity.getWindow().getDecorView();
            DisplayCutout displayCutout = decorView.getRootWindowInsets().getDisplayCutout();
            return displayCutout.getSafeInsetTop();
        }
        catch (Exception exception) {
            return -1;
        }
    }

    @TargetApi(value=28)
    public static int getSafeInsetRight(Activity activity) {
        try {
            View decorView = activity.getWindow().getDecorView();
            DisplayCutout displayCutout = decorView.getRootWindowInsets().getDisplayCutout();
            return displayCutout.getSafeInsetRight();
        }
        catch (Exception exception) {
            return -1;
        }
    }

    @TargetApi(value=28)
    public static int getSafeInsetBottom(Activity activity) {
        try {
            View decorView = activity.getWindow().getDecorView();
            DisplayCutout displayCutout = decorView.getRootWindowInsets().getDisplayCutout();
            return displayCutout.getSafeInsetBottom();
        }
        catch (Exception exception) {
            return -1;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static boolean hasNotchAtHuawei(Context context) {
        boolean ret = false;
        try {
            ClassLoader cl = context.getClassLoader();
            Class<?> HwNotchSizeUtil = cl.loadClass("com.huawei.android.util.HwNotchSizeUtil");
            Method get = HwNotchSizeUtil.getMethod("hasNotchInScreen", new Class[0]);
            ret = (Boolean)get.invoke(HwNotchSizeUtil, new Object[0]);
            return ret;
        }
        catch (ClassNotFoundException classNotFoundException) {}
        catch (NoSuchMethodException noSuchMethodException) {}
        catch (Exception exception) {}
        finally {
            return ret;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static int[] getNotchSizeAtHuawei(Context context) {
        int[] ret = new int[]{0, 0};
        try {
            ClassLoader cl = context.getClassLoader();
            Class<?> HwNotchSizeUtil = cl.loadClass("com.huawei.android.util.HwNotchSizeUtil");
            Method get = HwNotchSizeUtil.getMethod("getNotchSize", new Class[0]);
            ret = (int[])get.invoke(HwNotchSizeUtil, new Object[0]);
            return ret;
        }
        catch (ClassNotFoundException classNotFoundException) {}
        catch (NoSuchMethodException noSuchMethodException) {}
        catch (Exception exception) {}
        finally {
            return ret;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static boolean hasNotchAtVivo(Context context) {
        boolean ret = false;
        try {
            ClassLoader classLoader = context.getClassLoader();
            Class<?> FtFeature = classLoader.loadClass("android.util.FtFeature");
            Method method = FtFeature.getMethod("isFeatureSupport", Integer.TYPE);
            ret = (Boolean)method.invoke(FtFeature, 32);
            return ret;
        }
        catch (ClassNotFoundException classNotFoundException) {}
        catch (NoSuchMethodException noSuchMethodException) {}
        catch (Exception exception) {}
        finally {
            return ret;
        }
    }

    public static int[] getNotchSizeAtVivo(Context context) {
        return new int[]{ScreenUtil.dp2px(context, 100.0f), ScreenUtil.dp2px(context, 80.0f)};
    }

    public static boolean hasNotchAtOppo(Context context) {
        boolean ret = false;
        try {
            ret = context.getPackageManager().hasSystemFeature("com.oppo.feature.screen.heteromorphism");
            return ret;
        }
        catch (Exception exception) {}
        finally {
            return ret;
        }
    }

    public static int[] getNotchSizeAtOppo() {
        return new int[]{324, 80};
    }

    public static boolean hasNotchAtXiaomi(Context context) {
        boolean ret = false;
        try {
            ret = SystemPropertiesProxy.getInt(context, "ro.miui.notch", 0) == 1;
            return ret;
        }
        catch (Exception exception) {}
        finally {
            return ret;
        }
    }

    public static int[] getNotchSizeAtXiaomi(Context context) {
        return new int[]{0, ScreenUtil.getStatusBarHeight(context)};
    }
}

