/*
 * Decompiled with CFR 0.152.
 */
package com.android.gymchina.framework.utils;

import android.os.Build;
import android.text.TextUtils;
import android.util.Log;
import java.io.BufferedReader;
import java.io.IOException;
import java.io.InputStreamReader;

public class RomUtils {
    private static final String TAG = RomUtils.class.getSimpleName();

    private RomUtils() {
        throw new UnsupportedOperationException("cannot be instantiated");
    }

    public static double getEmuiVersion() {
        try {
            String emuiVersion = RomUtils.getSystemProperty("ro.build.version.emui");
            String version = emuiVersion.substring(emuiVersion.indexOf("_") + 1);
            return Double.parseDouble(version);
        }
        catch (Exception e) {
            e.printStackTrace();
            return 4.0;
        }
    }

    public static int getMiuiVersion() {
        String version = RomUtils.getSystemProperty("ro.miui.ui.version.name");
        if (version != null) {
            try {
                return Integer.parseInt(version.substring(1));
            }
            catch (Exception e) {
                Log.e((String)TAG, (String)("get miui version code error, version : " + version));
            }
        }
        return -1;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static String getSystemProperty(String propName) {
        String line;
        BufferedReader input = null;
        try {
            Process p = Runtime.getRuntime().exec("getprop " + propName);
            input = new BufferedReader(new InputStreamReader(p.getInputStream()), 1024);
            line = input.readLine();
            input.close();
        }
        catch (IOException ex) {
            Log.e((String)TAG, (String)("Unable to read sysprop " + propName), (Throwable)ex);
            String string = null;
            return string;
        }
        finally {
            if (input != null) {
                try {
                    input.close();
                }
                catch (IOException e) {
                    Log.e((String)TAG, (String)"Exception while closing InputStream", (Throwable)e);
                }
            }
        }
        return line;
    }

    public static boolean checkIsHuaweiRom() {
        return Build.MANUFACTURER.contains("HUAWEI");
    }

    public static boolean checkIsMiuiRom() {
        return !TextUtils.isEmpty((CharSequence)RomUtils.getSystemProperty("ro.miui.ui.version.name"));
    }

    public static boolean checkIsMeizuRom() {
        String meizuFlymeOSFlag = RomUtils.getSystemProperty("ro.build.display.id");
        if (TextUtils.isEmpty((CharSequence)meizuFlymeOSFlag)) {
            return false;
        }
        return meizuFlymeOSFlag.contains("flyme") || meizuFlymeOSFlag.toLowerCase().contains("flyme");
    }

    public static boolean checkIs360Rom() {
        return Build.MANUFACTURER.contains("QiKU") || Build.MANUFACTURER.contains("360");
    }

    public static boolean checkIsOppoRom() {
        String oppoFlag = RomUtils.getSystemProperty("ro.build.version.opporom");
        return oppoFlag != null && !TextUtils.isEmpty((CharSequence)oppoFlag);
    }

    public static boolean checkIsVivoRom() {
        String vivoFlag = RomUtils.getSystemProperty("ro.vivo.os.version");
        return vivoFlag != null && !TextUtils.isEmpty((CharSequence)vivoFlag);
    }
}

