/*
 * Decompiled with CFR 0.152.
 */
package com.android.gymchina.framework.utils;

import android.graphics.Bitmap;
import android.media.MediaMetadataRetriever;
import android.support.annotation.Nullable;
import com.android.gymchina.framework.utils.FileUtil;
import com.android.gymchina.framework.utils.StringUtil;
import java.io.File;

public class MediaUtil {
    private MediaUtil() {
        throw new UnsupportedOperationException("cannot be instantiated");
    }

    @Nullable
    public static Bitmap getFrameFromFile(String filePath) {
        if (StringUtil.isNotNull(filePath)) {
            try {
                MediaMetadataRetriever media = new MediaMetadataRetriever();
                media.setDataSource(filePath);
                return media.getFrameAtTime();
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
        return null;
    }

    public static long getMediaDuration(String filePath) {
        File file;
        long duration = 0L;
        if (StringUtil.isNotNull(filePath) && (file = new File(filePath)).exists() && !file.isDirectory()) {
            try {
                MediaMetadataRetriever media = new MediaMetadataRetriever();
                media.setDataSource(filePath);
                long fileSize = FileUtil.getFileSize(file);
                long bitRate = Long.parseLong(media.extractMetadata(20));
                duration = fileSize * 8L / bitRate;
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
        return duration;
    }
}

