/*
 * Decompiled with CFR 0.152.
 */
package com.android.gymchina.framework.utils;

import android.content.Context;
import android.graphics.Bitmap;
import android.graphics.drawable.Drawable;
import android.support.annotation.DrawableRes;
import android.support.annotation.NonNull;
import android.support.annotation.Nullable;
import android.widget.ImageView;
import com.bumptech.glide.Glide;
import com.bumptech.glide.load.DataSource;
import com.bumptech.glide.load.Transformation;
import com.bumptech.glide.load.engine.GlideException;
import com.bumptech.glide.load.resource.bitmap.BitmapTransformation;
import com.bumptech.glide.load.resource.bitmap.CircleCrop;
import com.bumptech.glide.load.resource.bitmap.RoundedCorners;
import com.bumptech.glide.request.RequestListener;
import com.bumptech.glide.request.RequestOptions;
import com.bumptech.glide.request.target.SimpleTarget;
import com.bumptech.glide.request.target.Target;
import com.bumptech.glide.request.transition.Transition;

public final class ImageLoader {
    private ImageLoader() {
        throw new UnsupportedOperationException("cannot be instantiated");
    }

    private static IRequestOptions getRequestOptions() {
        return new IRequestOptions();
    }

    public static void loadImage(Context ctx, String url, ImageView imageView) {
        Glide.with((Context)ctx).load(url).into(imageView);
    }

    public static void loadImage(Context ctx, @DrawableRes int image, ImageView imageView) {
        Glide.with((Context)ctx).load(Integer.valueOf(image)).into(imageView);
    }

    public static void loadImage(Context ctx, String url, RequestOptions requestOptions, ImageView imageView) {
        Glide.with((Context)ctx).load(url).apply(requestOptions).into(imageView);
    }

    public static void loadImage(Context ctx, @DrawableRes int image, RequestOptions requestOptions, ImageView imageView) {
        Glide.with((Context)ctx).load(Integer.valueOf(image)).apply(requestOptions).into(imageView);
    }

    public static void loadImage(Context ctx, String url, @DrawableRes int loadImage, @DrawableRes int errorImage, ImageView imageView) {
        RequestOptions requestOptions = ImageLoader.getRequestOptions().placeholder(loadImage).error(errorImage).build();
        ImageLoader.loadImage(ctx, url, requestOptions, imageView);
    }

    public static void loadImage(Context ctx, String url, @DrawableRes int loadImage, @DrawableRes int errorImage, BitmapTransformation transformation, ImageView imageView) {
        RequestOptions requestOptions = ImageLoader.getRequestOptions().placeholder(loadImage).error(errorImage).transform(transformation).build();
        ImageLoader.loadImage(ctx, url, requestOptions, imageView);
    }

    public static void loadImage(Context ctx, String url, BitmapTransformation transformation, ImageView imageView) {
        RequestOptions requestOptions = ImageLoader.getRequestOptions().transform(transformation).build();
        ImageLoader.loadImage(ctx, url, requestOptions, imageView);
    }

    public static void loadImage(Context ctx, @DrawableRes int image, BitmapTransformation transformation, ImageView imageView) {
        RequestOptions requestOptions = ImageLoader.getRequestOptions().transform(transformation).build();
        ImageLoader.loadImage(ctx, image, requestOptions, imageView);
    }

    public static void loadImageCircle(Context ctx, String url, ImageView imageView) {
        ImageLoader.loadImage(ctx, url, (BitmapTransformation)new CircleCrop(), imageView);
    }

    public static void loadImageCircle(Context ctx, String url, @DrawableRes int loadImage, @DrawableRes int errorImage, ImageView imageView) {
        ImageLoader.loadImage(ctx, url, loadImage, errorImage, (BitmapTransformation)new CircleCrop(), imageView);
    }

    public static void loadImageCircle(Context ctx, @DrawableRes int image, ImageView imageView) {
        ImageLoader.loadImage(ctx, image, (BitmapTransformation)new CircleCrop(), imageView);
    }

    public static void loadImageRound(Context ctx, String url, ImageView imageView, int radius) {
        ImageLoader.loadImage(ctx, url, (BitmapTransformation)new RoundedCorners(radius), imageView);
    }

    public static void loadImageRound(Context ctx, String url, @DrawableRes int loadImage, @DrawableRes int errorImage, ImageView imageView, int radius) {
        ImageLoader.loadImage(ctx, url, loadImage, errorImage, (BitmapTransformation)new RoundedCorners(radius), imageView);
    }

    public static void loadImageRound(Context ctx, @DrawableRes int image, ImageView imageView, int radius) {
        ImageLoader.loadImage(ctx, image, (BitmapTransformation)new RoundedCorners(radius), imageView);
    }

    public static void loadImageSize(Context ctx, String url, ImageView imageView, int width, int height) {
        RequestOptions requestOptions = ImageLoader.getRequestOptions().resize(width, height).build();
        ImageLoader.loadImage(ctx, url, requestOptions, imageView);
    }

    public static void loadImageSize(Context ctx, @DrawableRes int image, ImageView imageView, int width, int height) {
        RequestOptions requestOptions = ImageLoader.getRequestOptions().resize(width, height).build();
        ImageLoader.loadImage(ctx, image, requestOptions, imageView);
    }

    public static void loadImageCallback(Context ctx, final String url, final ImageView imageView, final LoadImageCallback callback) {
        Glide.with((Context)ctx).load(url).listener((RequestListener)new RequestListener<Drawable>(){

            public boolean onLoadFailed(@Nullable GlideException e, Object model, Target<Drawable> target, boolean isFirstResource) {
                if (callback != null) {
                    callback.onImageFailed((Exception)e, url, imageView);
                }
                return false;
            }

            public boolean onResourceReady(Drawable resource, Object model, Target<Drawable> target, DataSource dataSource, boolean isFirstResource) {
                if (callback != null) {
                    callback.onImageLoaded(url, imageView);
                }
                return false;
            }
        }).into(imageView);
    }

    public static void loadBitmapCallback(Context ctx, final String url, final LoadTypeCallback<Bitmap> callback) {
        Glide.with((Context)ctx).asBitmap().load(url).listener((RequestListener)new RequestListener<Bitmap>(){

            public boolean onLoadFailed(@Nullable GlideException e, Object model, Target<Bitmap> target, boolean isFirstResource) {
                if (callback != null) {
                    callback.onTypeFailed((Exception)e, url);
                }
                return false;
            }

            public boolean onResourceReady(Bitmap resource, Object model, Target<Bitmap> target, DataSource dataSource, boolean isFirstResource) {
                return false;
            }
        }).into((Target)new SimpleTarget<Bitmap>(){

            public void onResourceReady(@NonNull Bitmap resource, @Nullable Transition<? super Bitmap> transition) {
                if (callback != null) {
                    callback.onTypeLoaded(resource, url);
                }
            }
        });
    }

    public static void loadDrawableCallback(Context ctx, final String url, final LoadTypeCallback<Drawable> callback) {
        Glide.with((Context)ctx).asDrawable().load(url).listener((RequestListener)new RequestListener<Drawable>(){

            public boolean onLoadFailed(@Nullable GlideException e, Object model, Target<Drawable> target, boolean isFirstResource) {
                if (callback != null) {
                    callback.onTypeFailed((Exception)e, url);
                }
                return false;
            }

            public boolean onResourceReady(Drawable resource, Object model, Target<Drawable> target, DataSource dataSource, boolean isFirstResource) {
                return false;
            }
        }).into((Target)new SimpleTarget<Drawable>(){

            public void onResourceReady(@NonNull Drawable resource, @Nullable Transition<? super Drawable> transition) {
                if (callback != null) {
                    callback.onTypeLoaded(resource, url);
                }
            }
        });
    }

    public static interface LoadTypeCallback<T> {
        public void onTypeLoaded(T var1, String var2);

        public void onTypeFailed(Exception var1, String var2);
    }

    public static interface LoadImageCallback {
        public void onPrepareLoad(String var1, ImageView var2);

        public void onImageLoaded(String var1, ImageView var2);

        public void onImageFailed(Exception var1, String var2, ImageView var3);
    }

    private static class IRequestOptions {
        private RequestOptions requestOptions = new RequestOptions();

        public RequestOptions build() {
            return this.requestOptions;
        }

        public IRequestOptions placeholder(@DrawableRes int placeholder) {
            this.requestOptions = this.requestOptions.placeholder(placeholder);
            return this;
        }

        public IRequestOptions error(@DrawableRes int error) {
            this.requestOptions = this.requestOptions.error(error);
            return this;
        }

        public IRequestOptions transform(BitmapTransformation transformation) {
            this.requestOptions = this.requestOptions.transform((Transformation)transformation);
            return this;
        }

        public IRequestOptions resize(int width, int height) {
            this.requestOptions = this.requestOptions.override(width, height);
            return this;
        }
    }
}

