/*
 * Decompiled with CFR 0.152.
 */
package com.android.gymchina.framework.utils;

import com.android.gymchina.framework.utils.LogUtil;
import java.io.Closeable;
import java.io.File;
import java.io.FileFilter;

public final class FileUtil {
    public static final long B = 1L;
    public static final long KB = 1024L;
    public static final long MB = 0x100000L;
    public static final long GB = 0x40000000L;

    private FileUtil() {
        throw new UnsupportedOperationException("cannot be instantiated");
    }

    public static boolean deleteAllInDir(String dirPath) {
        return FileUtil.deleteAllInDir(FileUtil.getFileByPath(dirPath));
    }

    public static boolean deleteAllInDir(File dir) {
        return FileUtil.deleteFilesInDirWithFilter(dir, new FileFilter(){

            @Override
            public boolean accept(File pathname) {
                return true;
            }
        });
    }

    public static boolean deleteFilesInDirWithFilter(File dir, FileFilter filter) {
        if (dir == null) {
            return false;
        }
        if (!dir.exists()) {
            return true;
        }
        if (!dir.isDirectory()) {
            return false;
        }
        File[] files = dir.listFiles();
        if (files != null && files.length != 0) {
            File[] var3 = files;
            int var4 = files.length;
            for (int var5 = 0; var5 < var4; ++var5) {
                File file = var3[var5];
                if (!filter.accept(file) || !(file.isFile() ? !file.delete() : file.isDirectory() && !FileUtil.deleteDir(file))) continue;
                return false;
            }
        }
        return true;
    }

    public static boolean deleteDir(File dir) {
        if (dir == null) {
            return false;
        }
        if (!dir.exists()) {
            return true;
        }
        if (!dir.isDirectory()) {
            return false;
        }
        File[] files = dir.listFiles();
        if (files != null && files.length != 0) {
            File[] var2 = files;
            int var3 = files.length;
            for (int var4 = 0; var4 < var3; ++var4) {
                File file = var2[var4];
                if (!(file.isFile() ? !file.delete() : file.isDirectory() && !FileUtil.deleteDir(file))) continue;
                return false;
            }
        }
        return dir.delete();
    }

    public static boolean deleteFile(String srcFilePath) {
        return FileUtil.deleteFile(FileUtil.getFileByPath(srcFilePath));
    }

    public static boolean deleteFile(File file) {
        return file != null && (!file.exists() || file.isFile() && file.delete());
    }

    public static File getFileByPath(String filePath) {
        return FileUtil.isSpace(filePath) ? null : new File(filePath);
    }

    private static boolean isSpace(String s) {
        if (s == null) {
            return true;
        }
        int len = s.length();
        for (int i = 0; i < len; ++i) {
            if (Character.isWhitespace(s.charAt(i))) continue;
            return false;
        }
        return true;
    }

    public static boolean createFileByDeleteOldFile(File file) {
        if (file == null) {
            return false;
        }
        if (file.exists() && !file.delete()) {
            return false;
        }
        if (!FileUtil.createOrExistsDir(file.getParentFile())) {
            return false;
        }
        try {
            return file.createNewFile();
        }
        catch (Throwable var2) {
            return false;
        }
    }

    public static void closeIO(Closeable ... closeables) {
        if (closeables != null) {
            Closeable[] var1 = closeables;
            int var2 = closeables.length;
            for (int var3 = 0; var3 < var2; ++var3) {
                Closeable closeable = var1[var3];
                if (closeable == null) continue;
                try {
                    closeable.close();
                    continue;
                }
                catch (Throwable throwable) {
                    // empty catch block
                }
            }
        }
    }

    public static boolean rename(String filePath, String newName) {
        return FileUtil.rename(FileUtil.getFileByPath(filePath), newName);
    }

    public static boolean rename(File file, String newName) {
        if (file == null) {
            return false;
        }
        if (!file.exists()) {
            return false;
        }
        if (FileUtil.isSpace(newName)) {
            return false;
        }
        if (newName.equals(file.getName())) {
            return true;
        }
        File newFile = new File(file.getParent() + File.separator + newName);
        return !newFile.exists() && file.renameTo(newFile);
    }

    public static boolean createOrExistsDir(File file) {
        if (file == null || !(file.exists() ? file.isDirectory() : file.mkdirs())) {
            boolean result = false;
            return result;
        }
        boolean result = true;
        return result;
    }

    public static long getFileSize(String filePath) {
        return FileUtil.getFileSize(new File(filePath));
    }

    public static long getFileSize(File file) {
        long size = 0L;
        if (file.exists()) {
            try {
                size = file.length();
            }
            catch (Exception exception) {}
        } else {
            LogUtil.e(null, "\u83b7\u53d6\u6587\u4ef6\u5927\u5c0f, \u6587\u4ef6\u4e0d\u5b58\u5728!");
        }
        return size;
    }
}

