/*
 * Decompiled with CFR 0.152.
 */
package com.android.gymchina.framework.network.interceptor;

import android.text.TextUtils;
import java.io.IOException;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import okhttp3.FormBody;
import okhttp3.Headers;
import okhttp3.HttpUrl;
import okhttp3.Interceptor;
import okhttp3.MediaType;
import okhttp3.Request;
import okhttp3.RequestBody;
import okhttp3.Response;
import okio.Buffer;
import okio.BufferedSink;

public class BasicParamsInterceptor
implements Interceptor {
    private Map<String, String> queryParamsMap = new HashMap<String, String>();
    private Map<String, String> paramsMap = new HashMap<String, String>();
    private Map<String, String> headerParamsMap = new HashMap<String, String>();
    private List<String> headerLinesList = new ArrayList<String>();

    private BasicParamsInterceptor() {
    }

    public Response intercept(Interceptor.Chain chain) throws IOException {
        Request request = chain.request();
        Request.Builder requestBuilder = request.newBuilder();
        Headers.Builder headerBuilder = request.headers().newBuilder();
        if (this.headerParamsMap.size() > 0) {
            for (Map.Entry entry : this.headerParamsMap.entrySet()) {
                headerBuilder.add((String)entry.getKey(), (String)entry.getValue());
            }
        }
        if (this.headerLinesList.size() > 0) {
            for (String string : this.headerLinesList) {
                headerBuilder.add(string);
            }
            requestBuilder.headers(headerBuilder.build());
        }
        if (this.queryParamsMap.size() > 0) {
            request = this.injectParamsIntoUrl(request.url().newBuilder(), requestBuilder, this.queryParamsMap);
        }
        if (this.paramsMap.size() > 0 && this.canInjectIntoBody(request)) {
            FormBody.Builder formBodyBuilder = new FormBody.Builder();
            for (Map.Entry<String, String> entry : this.paramsMap.entrySet()) {
                formBodyBuilder.add(entry.getKey(), entry.getValue());
            }
            FormBody formBody = formBodyBuilder.build();
            String string2 = BasicParamsInterceptor.bodyToString(request.body());
            string2 = string2 + (string2.length() > 0 ? "&" : "") + BasicParamsInterceptor.bodyToString((RequestBody)formBody);
            requestBuilder.post(RequestBody.create((MediaType)MediaType.parse((String)"application/x-www-form-urlencoded;charset=UTF-8"), (String)string2));
        }
        request = requestBuilder.build();
        return chain.proceed(request);
    }

    private boolean canInjectIntoBody(Request request) {
        if (request == null) {
            return false;
        }
        if (!TextUtils.equals((CharSequence)request.method(), (CharSequence)"POST")) {
            return false;
        }
        RequestBody body = request.body();
        if (body == null) {
            return false;
        }
        MediaType mediaType = body.contentType();
        if (mediaType == null) {
            return false;
        }
        return TextUtils.equals((CharSequence)mediaType.subtype(), (CharSequence)"x-www-form-urlencoded");
    }

    private Request injectParamsIntoUrl(HttpUrl.Builder httpUrlBuilder, Request.Builder requestBuilder, Map<String, String> paramsMap) {
        if (paramsMap.size() > 0) {
            for (Map.Entry<String, String> entry : paramsMap.entrySet()) {
                httpUrlBuilder.addQueryParameter(entry.getKey(), entry.getValue());
            }
            requestBuilder.url(httpUrlBuilder.build());
            return requestBuilder.build();
        }
        return null;
    }

    private static String bodyToString(RequestBody request) {
        try {
            Buffer buffer = new Buffer();
            if (request == null) {
                return "";
            }
            request.writeTo((BufferedSink)buffer);
            return buffer.readUtf8();
        }
        catch (IOException e) {
            return "did not work";
        }
    }

    public static class Builder {
        BasicParamsInterceptor interceptor = new BasicParamsInterceptor();

        public BasicParamsInterceptor build() {
            return this.interceptor;
        }

        public Builder addParam(String key, String value) {
            this.interceptor.paramsMap.put(key, value);
            return this;
        }

        public Builder addParamsMap(Map<String, String> paramsMap) {
            this.interceptor.paramsMap.putAll(paramsMap);
            return this;
        }

        public Builder addHeaderParam(String key, String value) {
            this.interceptor.headerParamsMap.put(key, value);
            return this;
        }

        public Builder addHeaderParamsMap(Map<String, String> headerParamsMap) {
            this.interceptor.headerParamsMap.putAll(headerParamsMap);
            return this;
        }

        public Builder addHeaderLine(String headerLine) {
            int index = headerLine.indexOf(":");
            if (index == -1) {
                throw new IllegalArgumentException("Unexpected header: " + headerLine);
            }
            this.interceptor.headerLinesList.add(headerLine);
            return this;
        }

        public Builder addHeaderLinesList(List<String> headerLinesList) {
            for (String headerLine : headerLinesList) {
                int index = headerLine.indexOf(":");
                if (index == -1) {
                    throw new IllegalArgumentException("Unexpected header: " + headerLine);
                }
                this.interceptor.headerLinesList.add(headerLine);
            }
            return this;
        }

        public Builder addQueryParam(String key, String value) {
            this.interceptor.queryParamsMap.put(key, value);
            return this;
        }

        public Builder addQueryParamsMap(Map<String, String> queryParamsMap) {
            this.interceptor.queryParamsMap.putAll(queryParamsMap);
            return this;
        }
    }
}

